//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Functions related to PIC24F series hardware timers - Header
//
// Language: Microchip C30
//
// File:     hw_timer.h
// Author: S1axter - MyBitBox.com
// Created: 6/29/2013
//
//////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef __HW_TIMER_H__
#define __HW_TIMER_H__

//====================================================================================
// ALL timer interrupts must be defined in the user application as per the following 
// prototypes.  These interrupt functions are NOT handled by this HAL module.  If you
// do not define an interrupt function, the default interrupt will fire and things 
// could go sideways. You have been warned!
//====================================================================================
void __attribute__((interrupt,no_auto_psv)) _T1Interrupt( void );
void __attribute__((interrupt,no_auto_psv)) _T2Interrupt( void );
void __attribute__((interrupt,no_auto_psv)) _T3Interrupt( void );
void __attribute__((interrupt,no_auto_psv)) _T4Interrupt( void );
void __attribute__((interrupt,no_auto_psv)) _T5Interrupt( void );
//====================================================================================



typedef enum {
	TIMER_PRESCALE_1_256_	= 0b11,
	TIMER_PRESCALE_1_64_	= 0b10,
	TIMER_PRESCALE_1_8_		= 0b01,
	TIMER_PRESCALE_1_1_		= 0b00
}timer_prescale_t;

#define timer_basic_init(id,period, priority, prescale)	do{ \
switch(id){ \
case 1: timer_1_basic_init(period, priority, prescale); break; \
case 2: timer_2_basic_init(period, priority, prescale); break; \
case 3: timer_3_basic_init(period, priority, prescale); break; \
case 4: timer_4_basic_init(period, priority, prescale); break; \
case 5: timer_5_basic_init(period, priority, prescale); break; \
default: break; \
} \
}while(0)

#define timer_off(id)   timer_##id##_off()

// ------Timer Functions--------------------------------------------------------
// Timer Type A
// Timer 1
#define timer_1_on()							do{T1CONbits.TON = 1;}while(0)
#define timer_1_off()							do{T1CONbits.TON = 0;}while(0)
#define timer_1_run_set(val)					do{T1CONbits.TON = val;}while(0)
#define timer_1_run_get()						(T1CONbits.TON)

#define timer_1_idle_on()						do{T1CONbits.TSIDL = 0;}while(0)
#define timer_1_idle_off()						do{T1CONbits.TSIDL = 1;}while(0)
#define timer_1_idle_run_set(val)				do{T1CONbits.TSIDL = val;}while(0)
#define timer_1_idle_run_get()					(T1CONbits.TSIDL)

#define timer_1_mode_timer()					do{T1CONbits.TCS = 0; T1CONbits.TGATE = 0; T1CONbits.TSYNC = 0;}while(0)
#define timer_1_mode_gated()					do{T1CONbits.TCS = 0; T1CONbits.TGATE = 1; T1CONbits.TSYNC = 0;}while(0)
#define timer_1_mode_synchronous()				do{T1CONbits.TCS = 1; T1CONbits.TGATE = 0; T1CONbits.TSYNC = 1;}while(0)
#define timer_1_mode_asynchronous()				do{T1CONbits.TCS = 1; T1CONbits.TGATE = 0; T1CONbits.TSYNC = 0;}while(0)

#define timer_1_prescale_set(val)				do{T1CONbits.TCKPS = val;}while(0)

#define timer_1_clock_internal()				do{T1CONbits.TCS = 0;}while(0)
#define timer_1_clock_external()				do{T1CONbits.TCS = 1;}while(0)

#define timer_1_counter_get()					(TMR1)
#define timer_1_counter_clear()					do{TMR1 = 0x00;}while(0)

#define timer_1_period_get()					(PR1)
#define timer_1_period_set(val)					do{PR1 = val;}while(0)
#define timer_1_period_register()                               PR1

#define timer_1_interrupt_priority_set(val)		do{IPC0bits.T1IP = (val & 0b111);}while(0)
#define timer_1_interrupt_priority_get(val)		(IPC0bits.T1IP)

#define timer_1_interrupt_flag_get()			(IFS0bits.T1IF)
#define timer_1_interrupt_flag_clear()			do{IFS0bits.T1IF = 0;}while(0)

#define timer_1_interrupt_enable()				do{IEC0bits.T1IE = 1;}while(0)
#define timer_1_interrupt_disable()				do{IEC0bits.T1IE = 0;}while(0)

#define timer_1_basic_init(period, priority, prescale) \
do{                                                 \
    timer_1_off();                                  \
    timer_1_idle_off();                             \
    timer_1_mode_timer();                           \
    timer_1_counter_clear();                        \
    timer_1_interrupt_flag_clear();                 \
    timer_1_period_set(period);                     \
    timer_1_interrupt_priority_set(priority);       \
    timer_1_prescale_set(prescale);                 \
    timer_1_interrupt_enable();                     \
    timer_1_on();                                   \
                                                    \
}while(0)

// Timer Type B
// Timer 2
#define timer_2_on()							do{T2CONbits.TON = 1;}while(0)
#define timer_2_off()							do{T2CONbits.TON = 0;}while(0)
#define timer_2_run_set(val)					do{T2CONbits.TON = val;}while(0)
#define timer_2_run_get()						(T2CONbits.TON)

#define timer_2_idle_on()						do{T2CONbits.TSIDL = 0;}while(0)
#define timer_2_idle_off()						do{T2CONbits.TSIDL = 1;}while(0)
#define timer_2_idle_run_set(val)				do{T2CONbits.TSIDL = val;}while(0)
#define timer_2_idle_run_get()					(T2CONbits.TSIDL)

#define timer_2_mode_timer()					do{T2CONbits.TCS = 0; T2CONbits.TGATE = 0; }while(0)
#define timer_2_mode_gated()					do{T2CONbits.TCS = 0; T2CONbits.TGATE = 1; }while(0)
#define timer_2_mode_synchronous()				do{T2CONbits.TCS = 1; T2CONbits.TGATE = 0; }while(0)

#define timer_2_prescale_set(val)				do{T2CONbits.TCKPS = val;}while(0)

#define timer_2_clock_internal()				do{T2CONbits.TCS = 0;}while(0)
#define timer_2_clock_external()				do{T2CONbits.TCS = 1;}while(0)

#define timer_2_counter_get()					(TMR2)
#define timer_2_counter_clear()					do{TMR2 = 0x00;}while(0)

#define timer_2_period_get()					(PR2)
#define timer_2_period_set(val)					do{PR2 = val;}while(0)
#define timer_2_period_register()                               PR2

#define timer_2_interrupt_priority_set(val)		do{IPC1bits.T2IP = (val & 0b111);}while(0)
#define timer_2_interrupt_priority_get(val)		(IPC1bits.T2IP)

#define timer_2_interrupt_flag_get()			(IFS0bits.T2IF)
#define timer_2_interrupt_flag_clear()			do{IFS0bits.T2IF = 0;}while(0)

#define timer_2_interrupt_enable()				do{IEC0bits.T2IE = 1;}while(0)
#define timer_2_interrupt_disable()				do{IEC0bits.T2IE = 0;}while(0)

#define timer_2_basic_init(period, priority, prescale)						\
do{																			\
	timer_2_off();															\
	timer_2_idle_off();														\
	timer_2_mode_timer();													\
	timer_2_counter_clear();												\
	timer_2_interrupt_flag_clear();											\
	timer_2_period_set(period);												\
	timer_2_interrupt_priority_set(priority);								\
	timer_2_prescale_set(prescale);											\
	timer_2_interrupt_enable();												\
	timer_2_on();															\
																			\
}while(0)

// Timer Type C
// Timer 3
#define timer_3_on()							do{T3CONbits.TON = 1;}while(0)
#define timer_3_off()							do{T3CONbits.TON = 0;}while(0)
#define timer_3_run_set(val)					do{T3CONbits.TON = val;}while(0)
#define timer_3_run_get()						(T3CONbits.TON)

#define timer_3_idle_on()						do{T3CONbits.TSIDL = 0;}while(0)
#define timer_3_idle_off()						do{T3CONbits.TSIDL = 1;}while(0)
#define timer_3_idle_run_set(val)				do{T3CONbits.TSIDL = val;}while(0)
#define timer_3_idle_run_get()					(T3CONbits.TSIDL)

#define timer_3_mode_timer()					do{T3CONbits.TCS = 0; T3CONbits.TGATE = 0; }while(0)
#define timer_3_mode_gated()					do{T3CONbits.TCS = 0; T3CONbits.TGATE = 1; }while(0)
#define timer_3_mode_synchronous()				do{T3CONbits.TCS = 1; T3CONbits.TGATE = 0; }while(0)

#define timer_3_prescale_set(val)				do{T3CONbits.TCKPS = val;}while(0)

#define timer_3_clock_internal()				do{T3CONbits.TCS = 0;}while(0)
#define timer_3_clock_external()				do{T3CONbits.TCS = 1;}while(0)

#define timer_3_counter_get()					(TMR3)
#define timer_3_counter_clear()					do{TMR3 = 0x0000;}while(0)

#define timer_3_period_get()					(PR3)
#define timer_3_period_set(val)					do{PR3 = val;}while(0)
#define timer_3_period_register()                               PR3

#define timer_3_interrupt_priority_set(val)		do{IPC2bits.T3IP = (val & 0b111);}while(0)
#define timer_3_interrupt_priority_get(val)		(IPC2bits.T3IP)

#define timer_3_interrupt_flag_get()			(IFS0bits.T3IF)
#define timer_3_interrupt_flag_clear()			do{IFS0bits.T3IF = 0;}while(0)

#define timer_3_interrupt_enable()				do{IEC0bits.T3IE = 1;}while(0)
#define timer_3_interrupt_disable()				do{IEC0bits.T3IE = 0;}while(0)

#define timer_3_basic_init(period, priority, prescale)						\
do{																			\
	timer_3_off();															\
	timer_3_idle_off();														\
	timer_3_mode_timer();													\
	timer_3_counter_clear();												\
	timer_3_interrupt_flag_clear();											\
	timer_3_period_set(period);												\
	timer_3_interrupt_priority_set(priority);								\
	timer_3_prescale_set(prescale);											\
	timer_3_interrupt_enable();												\
	timer_3_on();															\
																			\
}while(0)

// Timer Type B
// Timer 4
#define timer_4_on()							do{T4CONbits.TON = 1;}while(0)
#define timer_4_off()							do{T4CONbits.TON = 0;}while(0)
#define timer_4_run_set(val)					do{T4CONbits.TON = val;}while(0)
#define timer_4_run_get()						(T4CONbits.TON)

#define timer_4_idle_on()						do{T4CONbits.TSIDL = 0;}while(0)
#define timer_4_idle_off()						do{T4CONbits.TSIDL = 1;}while(0)
#define timer_4_idle_run_set(val)				do{T4CONbits.TSIDL = val;}while(0)
#define timer_4_idle_run_get()					(T4CONbits.TSIDL)

#define timer_4_mode_timer()					do{T4CONbits.TCS = 0; T4CONbits.TGATE = 0; }while(0)
#define timer_4_mode_gated()					do{T4CONbits.TCS = 0; T4CONbits.TGATE = 1; }while(0)
#define timer_4_mode_synchronous()				do{T4CONbits.TCS = 1; T4CONbits.TGATE = 0; }while(0)

#define timer_4_prescale_set(val)				do{T4CONbits.TCKPS = val;}while(0)

#define timer_4_clock_internal()				do{T4CONbits.TCS = 0;}while(0)
#define timer_4_clock_external()				do{T4CONbits.TCS = 1;}while(0)

#define timer_4_counter_get()					(TMR4)
#define timer_4_counter_clear()					do{TMR4 = 0x00;}while(0)

#define timer_4_period_get()					(PR4)
#define timer_4_period_set(val)					do{PR4 = val;}while(0)
#define timer_4_period_register()                               PR4

#define timer_4_interrupt_priority_set(val)		do{IPC6bits.T4IP = (val & 0b111);}while(0)
#define timer_4_interrupt_priority_get(val)		(IPC6bits.T4IP)

#define timer_4_interrupt_flag_get()			(IFS1bits.T4IF)
#define timer_4_interrupt_flag_clear()			do{IFS1bits.T4IF = 0;}while(0)

#define timer_4_interrupt_enable()				do{IEC1bits.T4IE = 1;}while(0)
#define timer_4_interrupt_disable()				do{IEC1bits.T4IE = 0;}while(0)

#define timer_4_basic_init(period, priority, prescale)						\
do{																			\
	timer_4_off();															\
	timer_4_idle_off();														\
	timer_4_mode_timer();													\
	timer_4_counter_clear();												\
	timer_4_interrupt_flag_clear();											\
	timer_4_period_set(period);												\
	timer_4_interrupt_priority_set(priority);								\
	timer_4_prescale_set(prescale);											\
	timer_4_interrupt_enable();												\
	timer_4_on();															\
																			\
}while(0)

// Timer Type C
// Timer 5
#define timer_5_on()							do{T5CONbits.TON = 1;}while(0)
#define timer_5_off()							do{T5CONbits.TON = 0;}while(0)
#define timer_5_run_set(val)					do{T5CONbits.TON = val;}while(0)
#define timer_5_run_get()						(T5CONbits.TON)

#define timer_5_idle_on()						do{T5CONbits.TSIDL = 0;}while(0)
#define timer_5_idle_off()						do{T5CONbits.TSIDL = 1;}while(0)
#define timer_5_idle_run_set(val)				do{T5CONbits.TSIDL = val;}while(0)
#define timer_5_idle_run_get()					(T5CONbits.TSIDL)

#define timer_5_mode_timer()					do{T5CONbits.TCS = 0; T5CONbits.TGATE = 0; }while(0)
#define timer_5_mode_gated()					do{T5CONbits.TCS = 0; T5CONbits.TGATE = 1; }while(0)
#define timer_5_mode_synchronous()				do{T5CONbits.TCS = 1; T5CONbits.TGATE = 0; }while(0)

#define timer_5_prescale_set(val)				do{T5CONbits.TCKPS = val;}while(0)

#define timer_5_clock_internal()				do{T5CONbits.TCS = 0;}while(0)
#define timer_5_clock_external()				do{T5CONbits.TCS = 1;}while(0)

#define timer_5_counter_get()					(TMR5)
#define timer_5_counter_clear()					do{TMR5 = 0x0000;}while(0)

#define timer_5_period_get()					(PR5)
#define timer_5_period_set(val)					do{PR5 = val;}while(0)
#define timer_5_period_register()                               PR5

#define timer_5_interrupt_priority_set(val)		do{IPC7bits.T5IP = (val & 0b111);}while(0)
#define timer_5_interrupt_priority_get(val)		(IPC7bits.T5IP)

#define timer_5_interrupt_flag_get()			(IFS1bits.T5IF)
#define timer_5_interrupt_flag_clear()			do{IFS1bits.T5IF = 0;}while(0)

#define timer_5_interrupt_enable()				do{IEC1bits.T5IE = 1;}while(0)
#define timer_5_interrupt_disable()				do{IEC1bits.T5IE = 0;}while(0)

#define timer_5_basic_init(period, priority, prescale)						\
do{																			\
	timer_5_off();															\
	timer_5_idle_off();														\
	timer_5_mode_timer();													\
	timer_5_counter_clear();												\
	timer_5_interrupt_flag_clear();											\
	timer_5_period_set(period);												\
	timer_5_interrupt_priority_set(priority);								\
	timer_5_prescale_set(prescale);											\
	timer_5_interrupt_enable();												\
	timer_5_on();															\
																			\
}while(0)

// Functions
void timer_init();
void timer_setup(uint8_t id, uint8_t pri, timer_prescale_t prescale, uint32_t fcy, uint16_t freq);

#endif
