//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Functions related to PIC24F series hardware timers
//
// Language: Microchip C30
//
// File:     hw_timer.c
// Author: S1axter - MyBitBox.com
// Created: 6/29/2013
//
//////////////////////////////////////////////////////////////////////////////////////////////////////

#include "defs.h"

#include "timer.h"


void timer_init()

{
    T2CON = 0;
    T2CON = 0;
    T3CON = 0;
    T4CON = 0;
    T5CON = 0;
    return;
}

// Pass in the priority, prescale value, clock speed, desired frequency
// To calculate the clock value, take the system clock, divide it by the prescaler, divide that
// result by the desired frequency.  That result must be a 16 bit number

// Example: Set Timer 1 - System clock = 40MHz, prescale 64, desired frequency is 100ms or 10Hz
// hw_timer_set_period(id=1,pri,64, (40000000/64), 2) = 62500 which is 16 bit

// Example: Set Timer 2 - System clock = 40MHz, prescale 256, desired frequency is 10Hz
// hw_timer_set_period(id=1,pri,256, (40000000/256), 2) = 15625 which is 16 bit
void timer_setup(uint8_t id, uint8_t pri, timer_prescale_t prescale, uint32_t fcy, uint16_t freq)
{
    uint16_t temp16;
    // Don't allow invalid prescalers
    switch(prescale){
    case TIMER_PRESCALE_1_1_:
    case TIMER_PRESCALE_1_8_:
    case TIMER_PRESCALE_1_64_:
    case TIMER_PRESCALE_1_256_: break;
    default: return;
    }
    // This take the clock/the frequency we want (40Mhz/10KHz) =  4000
    temp16 = __builtin_divsd(fcy,freq);

    // id, period, priority, perscale_value
    switch(id){
    case 1: timer_1_basic_init(temp16, pri, prescale); break;
    case 2: timer_2_basic_init(temp16, pri, prescale); break;
    case 3: timer_3_basic_init(temp16, pri, prescale); break;
    case 4: timer_4_basic_init(temp16, pri, prescale); break;
    case 5: timer_5_basic_init(temp16, pri, prescale); break;
    default: break;
    }

    return;
}
//eof
