//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Software timer module (16-bit)
//
// This module uses 16-bit counters to work better with 16-bit architectures.
// This means the softtimers can only count to 65536.  At 1ms, this would be
// 65,536 sec max
//
// Language: C
//
// File:     swtimer.c
// Author: S1axter - MyBitBox.com
// Created: 6/29/2013
//
// This file was created to be processor agnostic, no architecture specific code
// or hardware access should be included.
//
//////////////////////////////////////////////////////////////////////////////////////////////////////

#include "defs.h"
#include "swtimer.h"

// This structure is define here however is externed so it can be
// used throught the whole program
swtimer_data_t g_swtimer_data;

void swtimer_process()
{
    if(g_swtimer_data.increment_value==0) return;

    {
        uint8_t x;
        uint16_t count;
        swtimer_obj_t * timer;

        count = g_swtimer_data.increment_value;
        g_swtimer_data.increment_value=0;
        // Loop over each timer, if enabled, process
        for(x=0;x<g_swtimer_data.timers_index;x++)
        {
            timer = g_swtimer_data.list[x];
            if(timer->enabled)
            {
                // Time is enabled, add the count, if over time, call callback
                timer->timecount+=count;
                if(timer->timecount>=timer->period)
                {
                    if(timer->callback!=NULL)
                        (timer->callback)();
                    else
                        nop(); //some default callback thing?

                    // Remove the period and continue
                    timer->timecount-=timer->period;
                }
            }
        }
    }
    
    return;
}

//end
