//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Port Header File For PIC24FVxxKA302
//
// This module should be processor independant for the PIC24 series.  Just change
// the portX_mask() definitions to match the ports on the proc and the different
// macros are generated.  If you use a port/pin that doesn't exist there will be
// a build error.
//
// Language: Microchip C30/XC16
//
// File:     port.h
//
// Author: S1axter - MyBitBox.com
// Created: 6/29/2013
//
//////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef __PORT_H__
#define __PORT_H__

#include "defs.h"

/*///////////////////// PORT MASKS /////////////////////////*/

//#ifdef __24FVxxKA301
/////////////////////// PIC24FVxxKA302 ONLY!  ////////////////////////////

// Processor: PIC24FVxxKA302
#define porta_mask()	0b0000000010011111
#define portb_mask()	0b1111111111111111
#define portc_mask()	0b0000000000000000
#define portd_mask()	0b0000000000000000
#define porte_mask()	0b0000000000000000
#define portf_mask()	0b0000000000000000
#define portg_mask()	0b0000000000000000


#define port_adc_all_digital()      do{porta_make_digital();portb_make_digital();portc_make_digital();}while(0)
#define port_adc_all_analog()       do{porta_make_analog();portb_make_analog();portc_make_analog();}while(0)
#define port_adc_make_digital(pin)  port_adc##pin##_make_digital()
#define port_adc_make_analog(pin)   port_adc##pin##_make_analog()
#define port_adc_make_input(pin)    port_adc##pin##_make_input()
#define port_adc_make_output(pin)   port_adc##pin##_make_output()
#define port_adc_is_analog(pin)     port_adc##pin##_is_analog()

#define port_adc0_make_digital()    do{porta_0_make_digital();}while(0)
#define port_adc1_make_digital()    do{porta_1_make_digital();}while(0)
#define port_adc2_make_digital()    do{portb_0_make_digital();}while(0)
#define port_adc3_make_digital()    do{portb_1_make_digital();}while(0)
#define port_adc4_make_digital()    do{portb_2_make_digital();}while(0)
#define port_adc5_make_digital()    (0)
#define port_adc6_make_digital()    (0)
#define port_adc7_make_digital()    (0)
#define port_adc8_make_digital()    (0)
#define port_adc9_make_digital()    do{portb_15_make_digital();}while(0)
#define port_adc10_make_digital()    do{portb_14_make_digital();}while(0)
#define port_adc11_make_digital()    do{portb_13_make_digital();}while(0)
#define port_adc12_make_digital()    do{portb_13_make_digital();}while(0)
#define port_adc13_make_digital()    do{porta_2_make_digital();}while(0)
#define port_adc14_make_digital()    do{porta_3_make_digital();}while(0)
#define port_adc15_make_digital()    do{portb_4_make_digital();}while(0)


#define port_adc0_make_analog()    do{porta_0_make_analog();}while(0)
#define port_adc1_make_analog()    do{porta_1_make_analog();}while(0)
#define port_adc2_make_analog()    do{portb_0_make_analog();}while(0)
#define port_adc3_make_analog()    do{portb_1_make_analog();}while(0)
#define port_adc4_make_analog()    do{portb_2_make_analog();}while(0)
#define port_adc5_make_analog()     (0)
#define port_adc6_make_analog()     (0)
#define port_adc7_make_analog()     (0)
#define port_adc8_make_analog()     (0)
#define port_adc9_make_analog()    do{portb_15_make_analog();}while(0)
#define port_adc10_make_analog()    do{portb_14_make_analog();}while(0)
#define port_adc11_make_analog()    do{portb_13_make_analog();}while(0)
#define port_adc12_make_analog()    do{portb_12_make_analog();}while(0)
#define port_adc13_make_analog()    do{porta_2_make_analog();}while(0)
#define port_adc14_make_analog()    do{porta_3_make_analog();}while(0)
#define port_adc15_make_analog()    do{portb_4_make_analog();}while(0)

#define port_adc0_make_input()    do{porta_0_make_input();}while(0)
#define port_adc1_make_input()    do{porta_1_make_input();}while(0)
#define port_adc2_make_input()    do{portb_0_make_input();}while(0)
#define port_adc3_make_input()    do{portb_1_make_input();}while(0)
#define port_adc4_make_input()    do{portb_2_make_input();}while(0)
#define port_adc5_make_input()    (0)
#define port_adc6_make_input()    (0)
#define port_adc7_make_input()    (0)
#define port_adc8_make_input()    (0)
#define port_adc9_make_input()    do{portb_15_make_input();}while(0)
#define port_adc10_make_input()    do{portb_14_make_input();}while(0)
#define port_adc11_make_input()    do{portb_13_make_input();}while(0)
#define port_adc12_make_input()    do{portb_12_make_input();}while(0)
#define port_adc13_make_input()    do{porta_2_make_input();}while(0)
#define port_adc14_make_input()    do{porta_3_make_input();}while(0)
#define port_adc15_make_input()    do{portb_4_make_input();}while(0)

#define port_adc0_make_output()    do{porta_0_make_output();}while(0)
#define port_adc1_make_output()    do{porta_1_make_output();}while(0)
#define port_adc2_make_output()    do{portb_0_make_output();}while(0)
#define port_adc3_make_output()    do{portb_1_make_output();}while(0)
#define port_adc4_make_output()    do{portb_2_make_output();}while(0)
#define port_adc5_make_output()     (0)
#define port_adc6_make_output()     (0)
#define port_adc7_make_output()     (0)
#define port_adc8_make_output()     (0)
#define port_adc9_make_output()    do{portb_15_make_output();}while(0)
#define port_adc10_make_output()    do{portb_14_make_output();}while(0)
#define port_adc11_make_output()    do{portb_13_make_output();}while(0)
#define port_adc12_make_output()    do{portb_12_make_output();}while(0)
#define port_adc13_make_output()    do{porta_2_make_output();}while(0)
#define port_adc14_make_output()    do{porta_3_make_output();}while(0)
#define port_adc15_make_output()    do{portb_4_make_output();}while(0)

#define port_adc0_is_analog()    (porta_0_is_analog())
#define port_adc1_is_analog()    (porta_1_is_analog())
#define port_adc2_is_analog()    (portb_0_is_analog())
#define port_adc3_is_analog()    (portb_1_is_analog())
#define port_adc4_is_analog()   (portb_2_is_analog())
#define port_adc9_is_analog()    (portb_15_is_analog())
#define port_adc10_is_analog()    (portb_14_is_analog())
#define port_adc11_is_analog()    (portb_13_is_analog())
#define port_adc12_is_analog()    (portb_12_is_analog())
#define port_adc13_is_analog()    (porta_2_is_analog())
#define port_adc14_is_analog()    (porta_3_is_analog())
#define port_adc15_is_analog()    (portb_4_is_analog())

// PIC24FV analog lines
#define porta_make_digital()    do{ANSA=0;}while(0)
#define porta_make_analog()    do{ANSA=0xFFFF;}while(0)
// digital
#define porta_pin_make_digital(pin) porta_##pin##_make_digital()
#define porta_0_make_digital()  do{ANSAbits.ANSA0 = 0;}while(0)
#define porta_1_make_digital()  do{ANSAbits.ANSA1 = 0;}while(0)
#define porta_2_make_digital()  do{ANSAbits.ANSA2 = 0;}while(0)
#define porta_3_make_digital()  do{ANSAbits.ANSA3 = 0;}while(0)
// analog
#define porta_pin_make_analog(pin) porta_##pin##_make_analog()
#define porta_0_make_analog()  do{ANSAbits.ANSA0 = 1;}while(0)
#define porta_1_make_analog()  do{ANSAbits.ANSA1 = 1;}while(0)
#define porta_2_make_analog()  do{ANSAbits.ANSA2 = 1;}while(0)
#define porta_3_make_analog()  do{ANSAbits.ANSA3 = 1;}while(0)
// check
#define porta_pin_is_analog(pin) porta_##pin##_is_analog()
#define porta_0_is_analog()  (ANSAbits.ANSA0 == 1)
#define porta_1_is_analog()  (ANSAbits.ANSA1 == 1)
#define porta_2_is_analog()  (ANSAbits.ANSA2 == 1)
#define porta_3_is_analog()  (ANSAbits.ANSA3 == 1)


#define portb_make_digital()    do{ANSB=0;}while(0)
#define portb_make_analog()     do{ANSB=0xFFFF;}while(0)
// digitial
#define portb_pin_make_digital(pin) portb_##pin##_make_digital()
#define portb_0_make_digital()      do{ANSBbits.ANSB0 = 0;}while(0)
#define portb_1_make_digital()      do{ANSBbits.ANSB1 = 0;}while(0)
#define portb_2_make_digital()      do{ANSBbits.ANSB2 = 0;}while(0)
#define portb_4_make_digital()      do{ANSBbits.ANSB4 = 0;}while(0)
#define portb_12_make_digital()     do{ANSBbits.ANSB12 = 0;}while(0)
#define portb_13_make_digital()     do{ANSBbits.ANSB13 = 0;}while(0)
#define portb_14_make_digital()     do{ANSBbits.ANSB14 = 0;}while(0)
#define portb_15_make_digital()     do{ANSBbits.ANSB15 = 0;}while(0)
// analog
#define portb_pin_make_analog(pin) portb_##pin##_make_analog()
#define portb_0_make_analog()      do{ANSBbits.ANSB0 = 1;}while(0)
#define portb_1_make_analog()      do{ANSBbits.ANSB1 = 1;}while(0)
#define portb_2_make_analog()      do{ANSBbits.ANSB2 = 1;}while(0)
#define portb_4_make_analog()      do{ANSBbits.ANSB4 = 1;}while(0)
#define portb_12_make_analog()     do{ANSBbits.ANSB12 = 1;}while(0)
#define portb_13_make_analog()     do{ANSBbits.ANSB13 = 1;}while(0)
#define portb_14_make_analog()     do{ANSBbits.ANSB14 = 1;}while(0)
#define portb_15_make_analog()     do{ANSBbits.ANSB15 = 1;}while(0)
// check
#define portb_pin_is_analog(pin) portb_##pin##_is_analog()
#define portb_0_is_analog()  (ANSBbits.ANSB0 == 1)
#define portb_1_is_analog()  (ANSBbits.ANSB1 == 1)
#define portb_2_is_analog()  (ANSBbits.ANSB2 == 1)
#define portb_4_is_analog()  (ANSBbits.ANSB4 == 1)
#define portb_12_is_analog()  (ANSBbits.ANSB12 == 1)
#define portb_13_is_analog()  (ANSBbits.ANSB13 == 1)
#define portb_14_is_analog()  (ANSBbits.ANSB14 == 1)
#define portb_15_is_analog()  (ANSBbits.ANSB15 == 1)


#define portc_make_digital()        do{ANSC=0;}while(0)
#define portc_make_analog()         do{ANSC=0xFFFF;}while(0)
// digital
#define portc_pin_make_digital(pin) portc_##pin##_make_digital()
// analog
#define portc_pin_make_analog(pin) portc_##pin##_make_analog()

//#endif


/*///////////////////// ALL PIC24/dsPIC PROCESSORS ////////////////////////////*/

/*///////////////////// PORT A ////////////////////////////*/
#if porta_mask() != 0
#define porta_make_output()				do{TRISA = 0x0000;}while(0)
#define porta_make_input()		        do{TRISA = 0xFFFF;}while(0)
#define porta_write(val)				do{LATA = (val & porta_mask());}while(0)
#define porta_read()					(PORTA & porta_mask())
#define porta_lat_read()				(LATA & porta_mask())
#define porta_make_output_low()         do{porta_make_output();porta_write(0x0000);}while(0);

#define porta_ub_make_output()			do{TRISA &= 0x00FF;}while(0)
#define porta_ub_make_input()		    do{TRISA |= 0xFF00;}while(0)
#define porta_ub_write(val)				do{LATA = ((LATA & 0x00FF) | ((val << 8) & 0xFF00)) & porta_mask();}while(0)
#define porta_ub_read()					(((PORTA & porta_mask()) >> 8) & 0x00FF )
#define porta_ub_lat_read()				(((LATA & porta_mask()) >> 8) & 0x00FF )

#define porta_lb_make_output()			do{TRISA &= 0xFF00;}while(0)
#define porta_lb_input()		        do{TRISA |= 0x00FF;}while(0)
#define porta_lb_write(val)				do{LATA = ((LATA & 0xFF00) | (val & 0x00FF)) & porta_mask();}while(0)
#define porta_lb_read()					(PORTA & 0x00FF & porta_mask())
#define porta_lb_lat_read()				(LATA & 0x00FF & porta_mask())

#define porta_ub_un_make_output()		do{TRISA &= 0x0FFF;}while(0)
#define porta_ub_un_make_input()		do{TRISA |= 0xF000;}while(0)
#define porta_ub_un_write(val)			do{LATA = ((LATA & 0x0FFF) | ((val << 12) & 0xF000)) & porta_mask();}while(0)
#define porta_ub_un_read()				(((PORTA & porta_mask()) >> 12) & 0x000F)
#define porta_ub_un_lat_read()			(((LATA & porta_mask()) >> 12) & 0x000F )

#define porta_ub_ln_make_output()		do{TRISA &= 0xF0FF;}while(0)
#define porta_ub_ln_make_input()		do{TRISA |= 0x0F00;}while(0)
#define porta_ub_ln_write(val)			do{LATA = ((LATA & 0xF0FF) | ((val << 8) & 0x0F00)) & porta_mask();}while(0)
#define porta_ub_ln_read()				(((PORTA & porta_mask()) >> 8) & 0x000F )
#define porta_ub_ln_lat_read()			(((LATA & porta_mask()) >> 8) & 0x000F )

#define porta_lb_un_make_output()		do{TRISA &= 0xFF0F;}while(0)
#define porta_lb_un_make_input()		do{TRISA |= 0x00F0;}while(0)
#define porta_lb_un_write(val)			do{LATA = ((LATA & 0xFF0F) | (val & 0x00F0)) & porta_mask();}while(0)
#define porta_lb_un_read()				(((PORTA & porta_mask()) >> 4) & 0x000F )
#define porta_lb_un_lat_read()			(((LATA& porta_mask()) >> 4) & 0x000F )

#define porta_lb_ln_make_output()		do{TRISA &= 0xFFF0;}while(0)
#define porta_lb_ln_make_input()		do{TRISA |= 0x000F;}while(0)
#define porta_lb_ln_write(val)			do{LATA = ((LATA & 0xFFF0) | (val & 0x000F)) & porta_mask();}while(0)
#define porta_lb_ln_read()				(PORTA & porta_mask() & 0x000F)
#define porta_lb_ln_lat_read()			(LATA & porta_mask() & 0x000F)

#define porta_pin_set(pin)            	    porta_##pin##_write(1)
#define porta_pin_clear(pin)            	porta_##pin##_write(0)
#define porta_pin_make_output(pin)		    porta_##pin##_make_output()
#define porta_pin_make_input(pin)		    porta_##pin##_make_input()
#define porta_pin_write(pin,val)      	    porta_##pin##_write(val)
#define porta_pin_read(pin)	        	    porta_##pin##_read()
#define porta_pin_lat_read(pin)	            porta_##pin##_lat_read()
#define porta_pin_toggle(pin)               porta_##pin##_toggle()
#endif

#if porta_mask()&0x0001
#define porta_0_make_output()			do{TRISAbits.TRISA0 = 0;}while(0)
#define porta_0_make_input()			do{TRISAbits.TRISA0 = 1;}while(0)
#define porta_0_write(val)				do{LATAbits.LATA0 = val;}while(0)
#define porta_0_read()					(PORTAbits.RA0)
#define porta_0_lat_read()				(LATAbits.LATA0)
#define porta_0_toggle()				do{__builtin_btg((uint16_t *)&LATA,0);}while(0)
#endif
#if porta_mask()&0x0002
#define porta_1_make_output()			do{TRISAbits.TRISA1 = 0;}while(0)
#define porta_1_make_input()			do{TRISAbits.TRISA1 = 1;}while(0)
#define porta_1_write(val)				do{LATAbits.LATA1 = val;}while(0)
#define porta_1_read()					(PORTAbits.RA1)
#define porta_1_lat_read()				(LATAbits.LATA1)
#define porta_1_toggle()				do{__builtin_btg((uint16_t *)&LATA,1);}while(0)
#endif
#if porta_mask()&0x0004
#define porta_2_make_output()			do{TRISAbits.TRISA2 = 0;}while(0)
#define porta_2_make_input()			do{TRISAbits.TRISA2 = 1;}while(0)
#define porta_2_write(val)				do{LATAbits.LATA2 = val;}while(0)
#define porta_2_read()					(PORTAbits.RA2)
#define porta_2_lat_read()				(LATAbits.LATA2)
#define porta_2_toggle()				do{__builtin_btg((uint16_t *)&LATA,2);}while(0)
#endif
#if porta_mask()&0x0008
#define porta_3_make_output()			do{TRISAbits.TRISA3 = 0;}while(0)
#define porta_3_make_input()			do{TRISAbits.TRISA3 = 1;}while(0)
#define porta_3_write(val)				do{LATAbits.LATA3 = val;}while(0)
#define porta_3_read()					(PORTAbits.RA3)
#define porta_3_lat_read()				(LATAbits.LATA3)
#define porta_3_toggle()				do{__builtin_btg((uint16_t *)&LATA,3);}while(0)
#endif
#if porta_mask()&0x0010
#define porta_4_make_output()			do{TRISAbits.TRISA4 = 0;}while(0)
#define porta_4_make_input()			do{TRISAbits.TRISA4 = 1;}while(0)
#define porta_4_write(val)				do{LATAbits.LATA4 = val;}while(0)
#define porta_4_read()					(PORTAbits.RA4)
#define porta_4_lat_read()				(LATAbits.LATA4)
#define porta_4_toggle()				do{__builtin_btg((uint16_t *)&LATA,4);}while(0)
#endif
#if porta_mask()&0x0020
#define porta_5_make_output()			do{TRISAbits.TRISA5 = 0;}while(0)
#define porta_5_make_input()			do{TRISAbits.TRISA5 = 1;}while(0)
#define porta_5_write(val)				do{LATAbits.LATA5 = val;}while(0)
#define porta_5_read()					(PORTAbits.RA5)
#define porta_5_lat_read()				(LATAbits.LATA5)
#define porta_5_toggle()				do{__builtin_btg((uint16_t *)&LATA,5);}while(0)
#endif
#if porta_mask()&0x0040
#define porta_6_make_output()			do{TRISAbits.TRISA6 = 0;}while(0)
#define porta_6_make_input()			do{TRISAbits.TRISA6 = 1;}while(0)
#define porta_6_write(val)				do{LATAbits.LATA6 = val;}while(0)
#define porta_6_read()					(PORTAbits.RA6)
#define porta_6_lat_read()				(LATAbits.LATA6)
#define porta_6_toggle()				do{__builtin_btg((uint16_t *)&LATA,6);}while(0)
#endif
#if porta_mask()&0x0080
#define porta_7_make_output()			do{TRISAbits.TRISA7 = 0;}while(0)
#define porta_7_make_input()			do{TRISAbits.TRISA7 = 1;}while(0)
#define porta_7_write(val)				do{LATAbits.LATA7 = val;}while(0)
#define porta_7_read()					(PORTAbits.RA7)
#define porta_7_lat_read()				(LATAbits.LATA7)
#define porta_7_toggle()				do{__builtin_btg((uint16_t *)&LATA,7);}while(0)
#endif
#if porta_mask()&0x0100
#define porta_8_make_output()			do{TRISAbits.TRISA8 = 0;}while(0)
#define porta_8_make_input()			do{TRISAbits.TRISA8 = 1;}while(0)
#define porta_8_write(val)				do{LATAbits.LATA8 = val;}while(0)
#define porta_8_read()					(PORTAbits.RA8)
#define porta_8_lat_read()				(LATAbits.LATA8)
#define porta_8_toggle()				do{__builtin_btg((uint16_t *)&LATA,8);}while(0)
#endif
#if porta_mask()&0x0200
#define porta_9_make_output()			do{TRISAbits.TRISA9 = 0;}while(0)
#define porta_9_make_input()			do{TRISAbits.TRISA9 = 1;}while(0)
#define porta_9_write(val)				do{LATAbits.LATA9 = val;}while(0)
#define porta_9_read()					(PORTAbits.RA9)
#define porta_9_lat_read()				(LATAbits.LATA9)
#define porta_9_toggle()				do{__builtin_btg((uint16_t *)&LATA,9);}while(0)
#endif
#if porta_mask()&0x0400
#define porta_10_make_output()			do{TRISAbits.TRISA10 = 0;}while(0)
#define porta_10_make_input()			do{TRISAbits.TRISA10 = 1;}while(0)
#define porta_10_write(val)				do{LATAbits.LATA10 = val;}while(0)
#define porta_10_read()					(PORTAbits.RA10)
#define porta_10_lat_read()				(LATAbits.LATA10)
#define porta_10_toggle()				do{__builtin_btg((uint16_t *)&LATA,10);}while(0)
#endif
#if porta_mask()&0x0800
#define porta_11_make_output()			do{TRISAbits.TRISA11 = 0;}while(0)
#define porta_11_make_input()			do{TRISAbits.TRISA11 = 1;}while(0)
#define porta_11_write(val)				do{LATAbits.LATA11 = val;}while(0)
#define porta_11_read()					(PORTAbits.RA11)
#define porta_11_lat_read()				(LATAbits.LATA11)
#define porta_11_toggle()				do{__builtin_btg((uint16_t *)&LATA,11);}while(0)
#endif
#if porta_mask()&0x1000
#define porta_12_make_output()			do{TRISAbits.TRISA12 = 0;}while(0)
#define porta_12_make_input()			do{TRISAbits.TRISA12 = 1;}while(0)
#define porta_12_write(val)				do{LATAbits.LATA12 = val;}while(0)
#define porta_12_read()					(PORTAbits.RA12)
#define porta_12_lat_read()				(LATAbits.LATA12)
#define porta_12_toggle()				do{__builtin_btg((uint16_t *)&LATA,12);}while(0)
#endif
#if porta_mask()&0x2000
#define porta_13_make_output()			do{TRISAbits.TRISA13 = 0;}while(0)
#define porta_13_make_input()			do{TRISAbits.TRISA13 = 1;}while(0)
#define porta_13_write(val)				do{LATAbits.LATA13 = val;}while(0)
#define porta_13_read()					(PORTAbits.RA13)
#define porta_13_lat_read()				(LATAbits.LATA13)
#define porta_13_toggle()				do{__builtin_btg((uint16_t *)&LATA,13);}while(0)
#endif
#if porta_mask()&0x4000
#define porta_14_make_output()			do{TRISAbits.TRISA14 = 0;}while(0)
#define porta_14_make_input()			do{TRISAbits.TRISA14 = 1;}while(0)
#define porta_14_write(val)				do{LATAbits.LATA14 = val;}while(0)
#define porta_14_read()					(PORTAbits.RA14)
#define porta_14_lat_read()				(LATAbits.LATA14)
#define porta_14_toggle()				do{__builtin_btg((uint16_t *)&LATA,14);}while(0)
#endif
#if porta_mask()&0x8000
#define porta_15_make_output()			do{TRISAbits.TRISA15 = 0;}while(0)
#define porta_15_make_input()			do{TRISAbits.TRISA15 = 0;}while(0)
#define porta_15_write(val)				do{LATAbits.LATA15 = val;}while(0)
#define porta_15_read()					(PORTAbits.RA15)
#define porta_15_lat_read()				(LATAbits.LATA15)
#define porta_15_toggle()				do{__builtin_btg((uint16_t *)&LATA,15);}while(0)
#endif

/*///////////////////// PORT B ////////////////////////////*/
#if portb_mask() != 0
#define portb_make_output()				do{TRISB = 0x0000;}while(0)
#define portb_make_input()		        do{TRISB = 0xFFFF;}while(0)
#define portb_write(val)				do{LATB = (val & portb_mask());}while(0)
#define portb_read()					(PORTB & portb_mask())
#define portb_lat_read()				(LATB & portb_mask())
#define portb_make_output_low()         do{portb_make_output();portb_write(0x0000);}while(0);

#define portb_ub_make_output()			do{TRISB &= 0x00FF;}while(0)
#define portb_ub_make_input()		    do{TRISB |= 0xFF00;}while(0)
#define portb_ub_write(val)				do{LATB = ((LATB & 0x00FF) | ((val << 8) & 0xFF00)) & portb_mask();}while(0)
#define portb_ub_read()					(((PORTB & portb_mask()) >> 8) & 0x00FF )
#define portb_ub_lat_read()				(((LATB & portb_mask()) >> 8) & 0x00FF )

#define portb_lb_make_output()			do{TRISB &= 0xFF00;}while(0)
#define portb_lb_input()		        do{TRISB |= 0x00FF;}while(0)
#define portb_lb_write(val)				do{LATB = ((LATB & 0xFF00) | (val & 0x00FF)) & portb_mask();}while(0)
#define portb_lb_read()					(PORTB & 0x00FF & portb_mask())
#define portb_lb_lat_read()				(LATB & 0x00FF & portb_mask())

#define portb_ub_un_make_output()		do{TRISB &= 0x0FFF;}while(0)
#define portb_ub_un_make_input()		do{TRISB |= 0xF000;}while(0)
#define portb_ub_un_write(val)			do{LATB = ((LATB & 0x0FFF) | ((val << 12) & 0xF000)) & portb_mask();}while(0)
#define portb_ub_un_read()				(((PORTB & portb_mask()) >> 12) & 0x000F)
#define portb_ub_un_lat_read()			(((LATB & portb_mask()) >> 12) & 0x000F )

#define portb_ub_ln_make_output()		do{TRISB &= 0xF0FF;}while(0)
#define portb_ub_ln_make_input()		do{TRISB |= 0x0F00;}while(0)
#define portb_ub_ln_write(val)			do{LATB = ((LATB & 0xF0FF) | ((val << 8) & 0x0F00)) & portb_mask();}while(0)
#define portb_ub_ln_read()				(((PORTB & portb_mask()) >> 8) & 0x000F )
#define portb_ub_ln_lat_read()			(((LATB & portb_mask()) >> 8) & 0x000F )

#define portb_lb_un_make_output()		do{TRISB &= 0xFF0F;}while(0)
#define portb_lb_un_make_input()		do{TRISB |= 0x00F0;}while(0)
#define portb_lb_un_write(val)			do{LATB = ((LATB & 0xFF0F) | (val & 0x00F0)) & portb_mask();}while(0)
#define portb_lb_un_read()				(((PORTB & portb_mask()) >> 4) & 0x000F )
#define portb_lb_un_lat_read()			(((LATB& portb_mask()) >> 4) & 0x000F )

#define portb_lb_ln_make_output()		do{TRISB &= 0xFFF0;}while(0)
#define portb_lb_ln_make_input()		do{TRISB |= 0x000F;}while(0)
#define portb_lb_ln_write(val)			do{LATB = ((LATB & 0xFFF0) | (val & 0x000F)) & portb_mask();}while(0)
#define portb_lb_ln_read()				(PORTB & portb_mask() & 0x000F)
#define portb_lb_ln_lat_read()			(LATB & portb_mask() & 0x000F)

#define portb_pin_set(pin)            	    portb_##pin##_write(1)
#define portb_pin_clear(pin)            	portb_##pin##_write(0)
#define portb_pin_make_output(pin)		    portb_##pin##_make_output()
#define portb_pin_make_input(pin)		    portb_##pin##_make_input()
#define portb_pin_write(pin,val)      	    portb_##pin##_write(val)
#define portb_pin_read(pin)	        	    portb_##pin##_read()
#define portb_pin_lat_read(pin)	            portb_##pin##_lat_read()
#define portb_pin_toggle(pin)               portb_##pin##_toggle()
#endif

#if portb_mask()&0x0001
#define portb_0_make_output()			do{TRISBbits.TRISB0 = 0;}while(0)
#define portb_0_make_input()			do{TRISBbits.TRISB0 = 1;}while(0)
#define portb_0_write(val)				do{LATBbits.LATB0 = val;}while(0)
#define portb_0_read()					(PORTBbits.RB0)
#define portb_0_lat_read()				(LATBbits.LATB0)
#define portb_0_toggle()				do{__builtin_btg((uint16_t *)&LATB,0);}while(0)
#endif
#if portb_mask()&0x0002
#define portb_1_make_output()			do{TRISBbits.TRISB1 = 0;}while(0)
#define portb_1_make_input()			do{TRISBbits.TRISB1 = 1;}while(0)
#define portb_1_write(val)				do{LATBbits.LATB1 = val;}while(0)
#define portb_1_read()					(PORTBbits.RB1)
#define portb_1_lat_read()				(LATBbits.LATB1)
#define portb_1_toggle()				do{__builtin_btg((uint16_t *)&LATB,1);}while(0)
#endif
#if portb_mask()&0x0004
#define portb_2_make_output()			do{TRISBbits.TRISB2 = 0;}while(0)
#define portb_2_make_input()			do{TRISBbits.TRISB2 = 1;}while(0)
#define portb_2_write(val)				do{LATBbits.LATB2 = val;}while(0)
#define portb_2_read()					(PORTBbits.RB2)
#define portb_2_lat_read()				(LATBbits.LATB2)
#define portb_2_toggle()				do{__builtin_btg((uint16_t *)&LATB,2);}while(0)
#endif
#if portb_mask()&0x0008
#define portb_3_make_output()			do{TRISBbits.TRISB3 = 0;}while(0)
#define portb_3_make_input()			do{TRISBbits.TRISB3 = 1;}while(0)
#define portb_3_write(val)				do{LATBbits.LATB3 = val;}while(0)
#define portb_3_read()					(PORTBbits.RB3)
#define portb_3_lat_read()				(LATBbits.LATB3)
#define portb_3_toggle()				do{__builtin_btg((uint16_t *)&LATB,3);}while(0)
#endif
#if portb_mask()&0x0010
#define portb_4_make_output()			do{TRISBbits.TRISB4 = 0;}while(0)
#define portb_4_make_input()			do{TRISBbits.TRISB4 = 1;}while(0)
#define portb_4_write(val)				do{LATBbits.LATB4 = val;}while(0)
#define portb_4_read()					(PORTBbits.RB4)
#define portb_4_lat_read()				(LATBbits.LATB4)
#define portb_4_toggle()				do{__builtin_btg((uint16_t *)&LATB,4);}while(0)
#endif
#if portb_mask()&0x0020
#define portb_5_make_output()			do{TRISBbits.TRISB5 = 0;}while(0)
#define portb_5_make_input()			do{TRISBbits.TRISB5 = 1;}while(0)
#define portb_5_write(val)				do{LATBbits.LATB5 = val;}while(0)
#define portb_5_read()					(PORTBbits.RB5)
#define portb_5_lat_read()				(LATBbits.LATB5)
#define portb_5_toggle()				do{__builtin_btg((uint16_t *)&LATB,5);}while(0)
#endif
#if portb_mask()&0x0040
#define portb_6_make_output()			do{TRISBbits.TRISB6 = 0;}while(0)
#define portb_6_make_input()			do{TRISBbits.TRISB6 = 1;}while(0)
#define portb_6_write(val)				do{LATBbits.LATB6 = val;}while(0)
#define portb_6_read()					(PORTBbits.RB6)
#define portb_6_lat_read()				(LATBbits.LATB6)
#define portb_6_toggle()				do{__builtin_btg((uint16_t *)&LATB,6);}while(0)
#endif
#if portb_mask()&0x0080
#define portb_7_make_output()               do{TRISBbits.TRISB7 = 0;}while(0)
#define portb_7_make_input()                do{TRISBbits.TRISB7 = 1;}while(0)
#define portb_7_write(val)                  do{LATBbits.LATB7 = val;}while(0)
#define portb_7_read()                      (PORTBbits.RB7)
#define portb_7_lat_read()                  (LATBbits.LATB7)
#define portb_7_toggle()                    do{__builtin_btg((uint16_t *)&LATB,7);}while(0)
#endif
#if portb_mask()&0x0100
#define portb_8_make_output()               do{TRISBbits.TRISB8 = 0;}while(0)
#define portb_8_make_input()                do{TRISBbits.TRISB8 = 1;}while(0)
#define portb_8_write(val)                  do{LATBbits.LATB8 = val;}while(0)
#define portb_8_read()                      (PORTBbits.RB8)
#define portb_8_lat_read()                  (LATBbits.LATB8)
#define portb_8_toggle()                    do{__builtin_btg((uint16_t *)&LATB,8);}while(0)
#endif
#if portb_mask()&0x0200
#define portb_9_make_output()               do{TRISBbits.TRISB9 = 0;}while(0)
#define portb_9_make_input()                do{TRISBbits.TRISB9 = 1;}while(0)
#define portb_9_write(val)                  do{LATBbits.LATB9 = val;}while(0)
#define portb_9_read()                      (PORTBbits.RB9)
#define portb_9_lat_read()                  (LATBbits.LATB9)
#define portb_9_toggle()                    do{__builtin_btg((uint16_t *)&LATB,9);}while(0)
#endif
#if portb_mask()&0x0400
#define portb_10_make_output()			do{TRISBbits.TRISB10 = 0;}while(0)
#define portb_10_make_input()			do{TRISBbits.TRISB10 = 1;}while(0)
#define portb_10_write(val)				do{LATBbits.LATB10 = val;}while(0)
#define portb_10_read()					(PORTBbits.RB10)
#define portb_10_lat_read()				(LATBbits.LATB10)
#define portb_10_toggle()				do{__builtin_btg((uint16_t *)&LATB,10);}while(0)
#endif
#if portb_mask()&0x0800
#define portb_11_make_output()			do{TRISBbits.TRISB11 = 0;}while(0)
#define portb_11_make_input()			do{TRISBbits.TRISB11 = 1;}while(0)
#define portb_11_write(val)				do{LATBbits.LATB11 = val;}while(0)
#define portb_11_read()					(PORTBbits.RB11)
#define portb_11_lat_read()				(LATBbits.LATB11)
#define portb_11_toggle()				do{__builtin_btg((uint16_t *)&LATB,11);}while(0)
#endif
#if portb_mask()&0x1000
#define portb_12_make_output()			do{TRISBbits.TRISB12 = 0;}while(0)
#define portb_12_make_input()			do{TRISBbits.TRISB12 = 1;}while(0)
#define portb_12_write(val)				do{LATBbits.LATB12 = val;}while(0)
#define portb_12_read()					(PORTBbits.RB12)
#define portb_12_lat_read()				(LATBbits.LATB12)
#define portb_12_toggle()				do{__builtin_btg((uint16_t *)&LATB,12);}while(0)
#endif
#if portb_mask()&0x2000
#define portb_13_make_output()			do{TRISBbits.TRISB13 = 0;}while(0)
#define portb_13_make_input()			do{TRISBbits.TRISB13 = 1;}while(0)
#define portb_13_write(val)				do{LATBbits.LATB13 = val;}while(0)
#define portb_13_read()					(PORTBbits.RB13)
#define portb_13_lat_read()				(LATBbits.LATB13)
#define portb_13_toggle()				do{__builtin_btg((uint16_t *)&LATB,13);}while(0)
#endif
#if portb_mask()&0x4000
#define portb_14_make_output()			do{TRISBbits.TRISB14 = 0;}while(0)
#define portb_14_make_input()			do{TRISBbits.TRISB14 = 1;}while(0)
#define portb_14_write(val)				do{LATBbits.LATB14 = val;}while(0)
#define portb_14_read()					(PORTBbits.RB14)
#define portb_14_lat_read()				(LATBbits.LATB14)
#define portb_14_toggle()				do{__builtin_btg((uint16_t *)&LATB,14);}while(0)
#endif
#if portb_mask()&0x8000
#define portb_15_make_output()			do{TRISBbits.TRISB15 = 0;}while(0)
#define portb_15_make_input()			do{TRISBbits.TRISB15 = 0;}while(0)
#define portb_15_write(val)				do{LATBbits.LATB15 = val;}while(0)
#define portb_15_read()					(PORTBbits.RB15)
#define portb_15_lat_read()				(LATBbits.LATB15)
#define portb_15_toggle()				do{__builtin_btg((uint16_t *)&LATB,15);}while(0)
#endif


/*///////////////////// PORT C ////////////////////////////*/
#if portc_mask() != 0
#define portc_make_output()				do{TRISC = 0x0000;}while(0)
#define portc_make_input()		        do{TRISC = 0xFFFF;}while(0)
#define portc_write(val)				do{LATC = (val & portc_mask());}while(0)
#define portc_read()					(PORTC & portc_mask())
#define portc_lat_read()				(LATC & portc_mask())
#define portc_make_output_low()         do{portc_make_output();portc_write(0x0000);}while(0);

#define portc_ub_make_output()			do{TRISC &= 0x00FF;}while(0)
#define portc_ub_make_input()		    do{TRISC |= 0xFF00;}while(0)
#define portc_ub_write(val)				do{LATC = ((LATC & 0x00FF) | ((val << 8) & 0xFF00)) & portc_mask();}while(0)
#define portc_ub_read()					(((PORTC & portc_mask()) >> 8) & 0x00FF )
#define portc_ub_lat_read()				(((LATC & portc_mask()) >> 8) & 0x00FF )

#define portc_lb_make_output()			do{TRISC &= 0xFF00;}while(0)
#define portc_lb_input()		        do{TRISC |= 0x00FF;}while(0)
#define portc_lb_write(val)				do{LATC = ((LATC & 0xFF00) | (val & 0x00FF)) & portc_mask();}while(0)
#define portc_lb_read()					(PORTC & 0x00FF & portc_mask())
#define portc_lb_lat_read()				(LATC & 0x00FF & portc_mask())

#define portc_ub_un_make_output()		do{TRISC &= 0x0FFF;}while(0)
#define portc_ub_un_make_input()		do{TRISC |= 0xF000;}while(0)
#define portc_ub_un_write(val)			do{LATC = ((LATC & 0x0FFF) | ((val << 12) & 0xF000)) & portc_mask();}while(0)
#define portc_ub_un_read()				(((PORTC & portc_mask()) >> 12) & 0x000F)
#define portc_ub_un_lat_read()			(((LATC & portc_mask()) >> 12) & 0x000F )

#define portc_ub_ln_make_output()		do{TRISC &= 0xF0FF;}while(0)
#define portc_ub_ln_make_input()		do{TRISC |= 0x0F00;}while(0)
#define portc_ub_ln_write(val)			do{LATC = ((LATC & 0xF0FF) | ((val << 8) & 0x0F00)) & portc_mask();}while(0)
#define portc_ub_ln_read()				(((PORTC & portc_mask()) >> 8) & 0x000F )
#define portc_ub_ln_lat_read()			(((LATC & portc_mask()) >> 8) & 0x000F )

#define portc_lb_un_make_output()		do{TRISC &= 0xFF0F;}while(0)
#define portc_lb_un_make_input()		do{TRISC |= 0x00F0;}while(0)
#define portc_lb_un_write(val)			do{LATC = ((LATC & 0xFF0F) | (val & 0x00F0)) & portc_mask();}while(0)
#define portc_lb_un_read()				(((PORTC & portc_mask()) >> 4) & 0x000F )
#define portc_lb_un_lat_read()			(((LATC& portc_mask()) >> 4) & 0x000F )

#define portc_lb_ln_make_output()		do{TRISC &= 0xFFF0;}while(0)
#define portc_lb_ln_make_input()		do{TRISC |= 0x000F;}while(0)
#define portc_lb_ln_write(val)			do{LATC = ((LATC & 0xFFF0) | (val & 0x000F)) & portc_mask();}while(0)
#define portc_lb_ln_read()				(PORTC & portc_mask() & 0x000F)
#define portc_lb_ln_lat_read()			(LATC & portc_mask() & 0x000F)

#define portc_pin_set(pin)            	    portc_##pin##_write(1)
#define portc_pin_clear(pin)            	portc_##pin##_write(0)
#define portc_pin_make_output(pin)		    portc_##pin##_make_output()
#define portc_pin_make_input(pin)		    portc_##pin##_make_input()
#define portc_pin_write(pin,val)      	    portc_##pin##_write(val)
#define portc_pin_read(pin)	        	    portc_##pin##_read()
#define portc_pin_lat_read(pin)	            portc_##pin##_lat_read()
#define portc_pin_toggle(pin)               portc_##pin##_toggle()
#endif

#if portc_mask()&0x0001
#define portc_0_make_output()			do{TRISCbits.TRISC0 = 0;}while(0)
#define portc_0_make_input()			do{TRISCbits.TRISC0 = 1;}while(0)
#define portc_0_write(val)				do{LATCbits.LATC0 = val;}while(0)
#define portc_0_read()					(PORTCbits.RC0)
#define portc_0_lat_read()				(LATCbits.LATC0)
#define portc_0_toggle()				do{__builtin_btg((uint16_t *)&LATC,0);}while(0)
#endif
#if portc_mask()&0x0002
#define portc_1_make_output()			do{TRISCbits.TRISC1 = 0;}while(0)
#define portc_1_make_input()			do{TRISCbits.TRISC1 = 1;}while(0)
#define portc_1_write(val)				do{LATCbits.LATC1 = val;}while(0)
#define portc_1_read()					(PORTCbits.RC1)
#define portc_1_lat_read()				(LATCbits.LATC1)
#define portc_1_toggle()				do{__builtin_btg((uint16_t *)&LATC,1);}while(0)
#endif
#if portc_mask()&0x0004
#define portc_2_make_output()			do{TRISCbits.TRISC2 = 0;}while(0)
#define portc_2_make_input()			do{TRISCbits.TRISC2 = 1;}while(0)
#define portc_2_write(val)				do{LATCbits.LATC2 = val;}while(0)
#define portc_2_read()					(PORTCbits.RC2)
#define portc_2_lat_read()				(LATCbits.LATC2)
#define portc_2_toggle()				do{__builtin_btg((uint16_t *)&LATC,2);}while(0)
#endif
#if portc_mask()&0x0008
#define portc_3_make_output()			do{TRISCbits.TRISC3 = 0;}while(0)
#define portc_3_make_input()			do{TRISCbits.TRISC3 = 1;}while(0)
#define portc_3_write(val)				do{LATCbits.LATC3 = val;}while(0)
#define portc_3_read()					(PORTCbits.RC3)
#define portc_3_lat_read()				(LATCbits.LATC3)
#define portc_3_toggle()				do{__builtin_btg((uint16_t *)&LATC,3);}while(0)
#endif
#if portc_mask()&0x0010
#define portc_4_make_output()			do{TRISCbits.TRISC4 = 0;}while(0)
#define portc_4_make_input()			do{TRISCbits.TRISC4 = 1;}while(0)
#define portc_4_write(val)				do{LATCbits.LATC4 = val;}while(0)
#define portc_4_read()					(PORTCbits.RC4)
#define portc_4_lat_read()				(LATCbits.LATC4)
#define portc_4_toggle()				do{__builtin_btg((uint16_t *)&LATC,4);}while(0)
#endif
#if portc_mask()&0x0020
#define portc_5_make_output()			do{TRISCbits.TRISC5 = 0;}while(0)
#define portc_5_make_input()			do{TRISCbits.TRISC5 = 1;}while(0)
#define portc_5_write(val)				do{LATCbits.LATC5 = val;}while(0)
#define portc_5_read()					(PORTCbits.RC5)
#define portc_5_lat_read()				(LATCbits.LATC5)
#define portc_5_toggle()				do{__builtin_btg((uint16_t *)&LATC,5);}while(0)
#endif
#if portc_mask()&0x0040
#define portc_6_make_output()			do{TRISCbits.TRISC6 = 0;}while(0)
#define portc_6_make_input()			do{TRISCbits.TRISC6 = 1;}while(0)
#define portc_6_write(val)				do{LATCbits.LATC6 = val;}while(0)
#define portc_6_read()					(PORTCbits.RC6)
#define portc_6_lat_read()				(LATCbits.LATC6)
#define portc_6_toggle()				do{__builtin_btg((uint16_t *)&LATC,6);}while(0)
#endif
#if portc_mask()&0x0080
#define portc_7_make_output()			do{TRISCbits.TRISC7 = 0;}while(0)
#define portc_7_make_input()			do{TRISCbits.TRISC7 = 1;}while(0)
#define portc_7_write(val)				do{LATCbits.LATC7 = val;}while(0)
#define portc_7_read()					(PORTCbits.RC7)
#define portc_7_lat_read()				(LATCbits.LATC7)
#define portc_7_toggle()				do{__builtin_btg((uint16_t *)&LATC,7);}while(0)
#endif
#if portc_mask()&0x0100
#define portc_8_make_output()			do{TRISCbits.TRISC8 = 0;}while(0)
#define portc_8_make_input()			do{TRISCbits.TRISC8 = 1;}while(0)
#define portc_8_write(val)				do{LATCbits.LATC8 = val;}while(0)
#define portc_8_read()					(PORTCbits.RC8)
#define portc_8_lat_read()				(LATCbits.LATC8)
#define portc_8_toggle()				do{__builtin_btg((uint16_t *)&LATC,8);}while(0)
#endif
#if portc_mask()&0x0200
#define portc_9_make_output()			do{TRISCbits.TRISC9 = 0;}while(0)
#define portc_9_make_input()			do{TRISCbits.TRISC9 = 1;}while(0)
#define portc_9_write(val)				do{LATCbits.LATC9 = val;}while(0)
#define portc_9_read()					(PORTCbits.RC9)
#define portc_9_lat_read()				(LATCbits.LATC9)
#define portc_9_toggle()				do{__builtin_btg((uint16_t *)&LATC,9);}while(0)
#endif
#if portc_mask()&0x0400
#define portc_10_make_output()			do{TRISCbits.TRISC10 = 0;}while(0)
#define portc_10_make_input()			do{TRISCbits.TRISC10 = 1;}while(0)
#define portc_10_write(val)				do{LATCbits.LATC10 = val;}while(0)
#define portc_10_read()					(PORTCbits.RC10)
#define portc_10_lat_read()				(LATCbits.LATC10)
#define portc_10_toggle()				do{__builtin_btg((uint16_t *)&LATC,10);}while(0)
#endif
#if portc_mask()&0x0800
#define portc_11_make_output()			do{TRISCbits.TRISC11 = 0;}while(0)
#define portc_11_make_input()			do{TRISCbits.TRISC11 = 1;}while(0)
#define portc_11_write(val)				do{LATCbits.LATC11 = val;}while(0)
#define portc_11_read()					(PORTCbits.RC11)
#define portc_11_lat_read()				(LATCbits.LATC11)
#define portc_11_toggle()				do{__builtin_btg((uint16_t *)&LATC,11);}while(0)
#endif
#if portc_mask()&0x1000
#define portc_12_make_output()			do{TRISCbits.TRISC12 = 0;}while(0)
#define portc_12_make_input()			do{TRISCbits.TRISC12 = 1;}while(0)
#define portc_12_write(val)				do{LATCbits.LATC12 = val;}while(0)
#define portc_12_read()					(PORTCbits.RC12)
#define portc_12_lat_read()				(LATCbits.LATC12)
#define portc_12_toggle()				do{__builtin_btg((uint16_t *)&LATC,12);}while(0)
#endif
#if portc_mask()&0x2000
#define portc_13_make_output()			do{TRISCbits.TRISC13 = 0;}while(0)
#define portc_13_make_input()			do{TRISCbits.TRISC13 = 1;}while(0)
#define portc_13_write(val)				do{LATCbits.LATC13 = val;}while(0)
#define portc_13_read()					(PORTCbits.RC13)
#define portc_13_lat_read()				(LATCbits.LATC13)
#define portc_13_toggle()				do{__builtin_btg((uint16_t *)&LATC,13);}while(0)
#endif
#if portc_mask()&0x4000
#define portc_14_make_output()			do{TRISCbits.TRISC14 = 0;}while(0)
#define portc_14_make_input()			do{TRISCbits.TRISC14 = 1;}while(0)
#define portc_14_write(val)				do{LATCbits.LATC14 = val;}while(0)
#define portc_14_read()					(PORTCbits.RC14)
#define portc_14_lat_read()				(LATCbits.LATC14)
#define portc_14_toggle()				do{__builtin_btg((uint16_t *)&LATC,14);}while(0)
#endif
#if portc_mask()&0x8000
#define portc_15_make_output()			do{TRISCbits.TRISC15 = 0;}while(0)
#define portc_15_make_input()			do{TRISCbits.TRISC15 = 0;}while(0)
#define portc_15_write(val)				do{LATCbits.LATC15 = val;}while(0)
#define portc_15_read()					(PORTCbits.RC15)
#define portc_15_lat_read()				(LATCbits.LATC15)
#define portc_15_toggle()				do{__builtin_btg((uint16_t *)&LATC,15);}while(0)
#endif

/*///////////////////// PORT D ////////////////////////////*/
#if portd_mask() != 0
#define portd_make_output()				do{TRISD = 0x0000;}while(0)
#define portd_make_input()		        do{TRISD = 0xFFFF;}while(0)
#define portd_write(val)				do{LATD = (val & portd_mask());}while(0)
#define portd_read()					(PORTD & portd_mask())
#define portd_lat_read()				(LATD & portd_mask())
#define portd_make_output_low()         do{portd_make_output();portd_write(0x0000);}while(0);

#define portd_ub_make_output()			do{TRISD &= 0x00FF;}while(0)
#define portd_ub_make_input()		    do{TRISD |= 0xFF00;}while(0)
#define portd_ub_write(val)				do{LATD = ((LATD & 0x00FF) | ((val << 8) & 0xFF00)) & portd_mask();}while(0)
#define portd_ub_read()					(((PORTD & portd_mask()) >> 8) & 0x00FF )
#define portd_ub_lat_read()				(((LATD & portd_mask()) >> 8) & 0x00FF )

#define portd_lb_make_output()			do{TRISD &= 0xFF00;}while(0)
#define portd_lb_input()		        do{TRISD |= 0x00FF;}while(0)
#define portd_lb_write(val)				do{LATD = ((LATD & 0xFF00) | (val & 0x00FF)) & portd_mask();}while(0)
#define portd_lb_read()					(PORTD & 0x00FF & portd_mask())
#define portd_lb_lat_read()				(LATD & 0x00FF & portd_mask())

#define portd_ub_un_make_output()		do{TRISD &= 0x0FFF;}while(0)
#define portd_ub_un_make_input()		do{TRISD |= 0xF000;}while(0)
#define portd_ub_un_write(val)			do{LATD = ((LATD & 0x0FFF) | ((val << 12) & 0xF000)) & portd_mask();}while(0)
#define portd_ub_un_read()				(((PORTD & portd_mask()) >> 12) & 0x000F)
#define portd_ub_un_lat_read()			(((LATD & portd_mask()) >> 12) & 0x000F )

#define portd_ub_ln_make_output()		do{TRISD &= 0xF0FF;}while(0)
#define portd_ub_ln_make_input()		do{TRISD |= 0x0F00;}while(0)
#define portd_ub_ln_write(val)			do{LATD = ((LATD & 0xF0FF) | ((val << 8) & 0x0F00)) & portd_mask();}while(0)
#define portd_ub_ln_read()				(((PORTD & portd_mask()) >> 8) & 0x000F )
#define portd_ub_ln_lat_read()			(((LATD & portd_mask()) >> 8) & 0x000F )

#define portd_lb_un_make_output()		do{TRISD &= 0xFF0F;}while(0)
#define portd_lb_un_make_input()		do{TRISD |= 0x00F0;}while(0)
#define portd_lb_un_write(val)			do{LATD = ((LATD & 0xFF0F) | (val & 0x00F0)) & portd_mask();}while(0)
#define portd_lb_un_read()				(((PORTD & portd_mask()) >> 4) & 0x000F )
#define portd_lb_un_lat_read()			(((LATD& portd_mask()) >> 4) & 0x000F )

#define portd_lb_ln_make_output()		do{TRISD &= 0xFFF0;}while(0)
#define portd_lb_ln_make_input()		do{TRISD |= 0x000F;}while(0)
#define portd_lb_ln_write(val)			do{LATD = ((LATD & 0xFFF0) | (val & 0x000F)) & portd_mask();}while(0)
#define portd_lb_ln_read()				(PORTD & portd_mask() & 0x000F)
#define portd_lb_ln_lat_read()			(LATD & portd_mask() & 0x000F)

#define portd_pin_set(pin)            	    portd_##pin##_write(1)
#define portd_pin_clear(pin)            	portd_##pin##_write(0)
#define portd_pin_make_output(pin)		    portd_##pin##_make_output()
#define portd_pin_make_input(pin)		    portd_##pin##_make_input()
#define portd_pin_write(pin,val)      	    portd_##pin##_write(val)
#define portd_pin_read(pin)	        	    portd_##pin##_read()
#define portd_pin_lat_read(pin)	            portd_##pin##_lat_read()
#define portd_pin_toggle(pin)               portd_##pin##_toggle()
#endif

#if portd_mask()&0x0001
#define portd_0_make_output()			do{TRISDbits.TRISD0 = 0;}while(0)
#define portd_0_make_input()			do{TRISDbits.TRISD0 = 1;}while(0)
#define portd_0_write(val)				do{LATDbits.LATD0 = val;}while(0)
#define portd_0_read()					(PORTDbits.RD0)
#define portd_0_lat_read()				(LATDbits.LATD0)
#define portd_0_toggle()				do{__builtin_btg((uint16_t *)&LATD,0);}while(0)
#endif
#if portd_mask()&0x0002
#define portd_1_make_output()			do{TRISDbits.TRISD1 = 0;}while(0)
#define portd_1_make_input()			do{TRISDbits.TRISD1 = 1;}while(0)
#define portd_1_write(val)				do{LATDbits.LATD1 = val;}while(0)
#define portd_1_read()					(PORTDbits.RD1)
#define portd_1_lat_read()				(LATDbits.LATD1)
#define portd_1_toggle()				do{__builtin_btg((uint16_t *)&LATD,1);}while(0)
#endif
#if portd_mask()&0x0004
#define portd_2_make_output()			do{TRISDbits.TRISD2 = 0;}while(0)
#define portd_2_make_input()			do{TRISDbits.TRISD2 = 1;}while(0)
#define portd_2_write(val)				do{LATDbits.LATD2 = val;}while(0)
#define portd_2_read()					(PORTDbits.RD2)
#define portd_2_lat_read()				(LATDbits.LATD2)
#define portd_2_toggle()				do{__builtin_btg((uint16_t *)&LATD,2);}while(0)
#endif
#if portd_mask()&0x0008
#define portd_3_make_output()			do{TRISDbits.TRISD3 = 0;}while(0)
#define portd_3_make_input()			do{TRISDbits.TRISD3 = 1;}while(0)
#define portd_3_write(val)				do{LATDbits.LATD3 = val;}while(0)
#define portd_3_read()					(PORTDbits.RD3)
#define portd_3_lat_read()				(LATDbits.LATD3)
#define portd_3_toggle()				do{__builtin_btg((uint16_t *)&LATD,3);}while(0)
#endif
#if portd_mask()&0x0010
#define portd_4_make_output()			do{TRISDbits.TRISD4 = 0;}while(0)
#define portd_4_make_input()			do{TRISDbits.TRISD4 = 1;}while(0)
#define portd_4_write(val)				do{LATDbits.LATD4 = val;}while(0)
#define portd_4_read()					(PORTDbits.RD4)
#define portd_4_lat_read()				(LATDbits.LATD4)
#define portd_4_toggle()				do{__builtin_btg((uint16_t *)&LATD,4);}while(0)
#endif
#if portd_mask()&0x0020
#define portd_5_make_output()			do{TRISDbits.TRISD5 = 0;}while(0)
#define portd_5_make_input()			do{TRISDbits.TRISD5 = 1;}while(0)
#define portd_5_write(val)				do{LATDbits.LATD5 = val;}while(0)
#define portd_5_read()					(PORTDbits.RD5)
#define portd_5_lat_read()				(LATDbits.LATD5)
#define portd_5_toggle()				do{__builtin_btg((uint16_t *)&LATD,5);}while(0)
#endif
#if portd_mask()&0x0040
#define portd_6_make_output()			do{TRISDbits.TRISD6 = 0;}while(0)
#define portd_6_make_input()			do{TRISDbits.TRISD6 = 1;}while(0)
#define portd_6_write(val)				do{LATDbits.LATD6 = val;}while(0)
#define portd_6_read()					(PORTDbits.RD6)
#define portd_6_lat_read()				(LATDbits.LATD6)
#define portd_6_toggle()				do{__builtin_btg((uint16_t *)&LATD,6);}while(0)
#endif
#if portd_mask()&0x0080
#define portd_7_make_output()			do{TRISDbits.TRISD7 = 0;}while(0)
#define portd_7_make_input()			do{TRISDbits.TRISD7 = 1;}while(0)
#define portd_7_write(val)				do{LATDbits.LATD7 = val;}while(0)
#define portd_7_read()					(PORTDbits.RD7)
#define portd_7_lat_read()				(LATDbits.LATD7)
#define portd_7_toggle()				do{__builtin_btg((uint16_t *)&LATD,7);}while(0)
#endif
#if portd_mask()&0x0100
#define portd_8_make_output()			do{TRISDbits.TRISD8 = 0;}while(0)
#define portd_8_make_input()			do{TRISDbits.TRISD8 = 1;}while(0)
#define portd_8_write(val)				do{LATDbits.LATD8 = val;}while(0)
#define portd_8_read()					(PORTDbits.RD8)
#define portd_8_lat_read()				(LATDbits.LATD8)
#define portd_8_toggle()				do{__builtin_btg((uint16_t *)&LATD,8);}while(0)
#endif
#if portd_mask()&0x0200
#define portd_9_make_output()			do{TRISDbits.TRISD9 = 0;}while(0)
#define portd_9_make_input()			do{TRISDbits.TRISD9 = 1;}while(0)
#define portd_9_write(val)				do{LATDbits.LATD9 = val;}while(0)
#define portd_9_read()					(PORTDbits.RD9)
#define portd_9_lat_read()				(LATDbits.LATD9)
#define portd_9_toggle()				do{__builtin_btg((uint16_t *)&LATD,9);}while(0)
#endif
#if portd_mask()&0x0400
#define portd_10_make_output()			do{TRISDbits.TRISD10 = 0;}while(0)
#define portd_10_make_input()			do{TRISDbits.TRISD10 = 1;}while(0)
#define portd_10_write(val)				do{LATDbits.LATD10 = val;}while(0)
#define portd_10_read()					(PORTDbits.RD10)
#define portd_10_lat_read()				(LATDbits.LATD10)
#define portd_10_toggle()				do{__builtin_btg((uint16_t *)&LATD,10);}while(0)
#endif
#if portd_mask()&0x0800
#define portd_11_make_output()			do{TRISDbits.TRISD11 = 0;}while(0)
#define portd_11_make_input()			do{TRISDbits.TRISD11 = 1;}while(0)
#define portd_11_write(val)				do{LATDbits.LATD11 = val;}while(0)
#define portd_11_read()					(PORTDbits.RD11)
#define portd_11_lat_read()				(LATDbits.LATD11)
#define portd_11_toggle()				do{__builtin_btg((uint16_t *)&LATD,11);}while(0)
#endif
#if portd_mask()&0x1000
#define portd_12_make_output()			do{TRISDbits.TRISD12 = 0;}while(0)
#define portd_12_make_input()			do{TRISDbits.TRISD12 = 1;}while(0)
#define portd_12_write(val)				do{LATDbits.LATD12 = val;}while(0)
#define portd_12_read()					(PORTDbits.RD12)
#define portd_12_lat_read()				(LATDbits.LATD12)
#define portd_12_toggle()				do{__builtin_btg((uint16_t *)&LATD,12);}while(0)
#endif
#if portd_mask()&0x2000
#define portd_13_make_output()			do{TRISDbits.TRISD13 = 0;}while(0)
#define portd_13_make_input()			do{TRISDbits.TRISD13 = 1;}while(0)
#define portd_13_write(val)				do{LATDbits.LATD13 = val;}while(0)
#define portd_13_read()					(PORTDbits.RD13)
#define portd_13_lat_read()				(LATDbits.LATD13)
#define portd_13_toggle()				do{__builtin_btg((uint16_t *)&LATD,13);}while(0)
#endif
#if portd_mask()&0x4000
#define portd_14_make_output()			do{TRISDbits.TRISD14 = 0;}while(0)
#define portd_14_make_input()			do{TRISDbits.TRISD14 = 1;}while(0)
#define portd_14_write(val)				do{LATDbits.LATD14 = val;}while(0)
#define portd_14_read()					(PORTDbits.RD14)
#define portd_14_lat_read()				(LATDbits.LATD14)
#define portd_14_toggle()				do{__builtin_btg((uint16_t *)&LATD,14);}while(0)
#endif
#if portd_mask()&0x8000
#define portd_15_make_output()			do{TRISDbits.TRISD15 = 0;}while(0)
#define portd_15_make_input()			do{TRISDbits.TRISD15 = 0;}while(0)
#define portd_15_write(val)				do{LATDbits.LATD15 = val;}while(0)
#define portd_15_read()					(PORTDbits.RD15)
#define portd_15_lat_read()				(LATDbits.LATD15)
#define portd_15_toggle()				do{__builtin_btg((uint16_t *)&LATD,15);}while(0)
#endif

/*///////////////////// PORT E ////////////////////////////*/
#if porte_mask() != 0
#define porte_make_output()				do{TRISE = 0x0000;}while(0)
#define porte_make_input()		        do{TRISE = 0xFFFF;}while(0)
#define porte_write(val)				do{LATE = (val & porte_mask());}while(0)
#define porte_read()					(PORTE & porte_mask())
#define porte_lat_read()				(LATE & porte_mask())
#define porte_make_output_low()         do{porte_make_output();porte_write(0x0000);}while(0);

#define porte_ub_make_output()			do{TRISE &= 0x00FF;}while(0)
#define porte_ub_make_input()		    do{TRISE |= 0xFF00;}while(0)
#define porte_ub_write(val)				do{LATE = ((LATE & 0x00FF) | ((val << 8) & 0xFF00)) & porte_mask();}while(0)
#define porte_ub_read()					(((PORTE & porte_mask()) >> 8) & 0x00FF )
#define porte_ub_lat_read()				(((LATE & porte_mask()) >> 8) & 0x00FF )

#define porte_lb_make_output()			do{TRISE &= 0xFF00;}while(0)
#define porte_lb_input()		        do{TRISE |= 0x00FF;}while(0)
#define porte_lb_write(val)				do{LATE = ((LATE & 0xFF00) | (val & 0x00FF)) & porte_mask();}while(0)
#define porte_lb_read()					(PORTE & 0x00FF & porte_mask())
#define porte_lb_lat_read()				(LATE & 0x00FF & porte_mask())

#define porte_ub_un_make_output()		do{TRISE &= 0x0FFF;}while(0)
#define porte_ub_un_make_input()		do{TRISE |= 0xF000;}while(0)
#define porte_ub_un_write(val)			do{LATE = ((LATE & 0x0FFF) | ((val << 12) & 0xF000)) & porte_mask();}while(0)
#define porte_ub_un_read()				(((PORTE & porte_mask()) >> 12) & 0x000F)
#define porte_ub_un_lat_read()			(((LATE & porte_mask()) >> 12) & 0x000F )

#define porte_ub_ln_make_output()		do{TRISE &= 0xF0FF;}while(0)
#define porte_ub_ln_make_input()		do{TRISE |= 0x0F00;}while(0)
#define porte_ub_ln_write(val)			do{LATE = ((LATE & 0xF0FF) | ((val << 8) & 0x0F00)) & porte_mask();}while(0)
#define porte_ub_ln_read()				(((PORTE & porte_mask()) >> 8) & 0x000F )
#define porte_ub_ln_lat_read()			(((LATE & porte_mask()) >> 8) & 0x000F )

#define porte_lb_un_make_output()		do{TRISE &= 0xFF0F;}while(0)
#define porte_lb_un_make_input()		do{TRISE |= 0x00F0;}while(0)
#define porte_lb_un_write(val)			do{LATE = ((LATE & 0xFF0F) | (val & 0x00F0)) & porte_mask();}while(0)
#define porte_lb_un_read()				(((PORTE & porte_mask()) >> 4) & 0x000F )
#define porte_lb_un_lat_read()			(((LATE& porte_mask()) >> 4) & 0x000F )

#define porte_lb_ln_make_output()		do{TRISE &= 0xFFF0;}while(0)
#define porte_lb_ln_make_input()		do{TRISE |= 0x000F;}while(0)
#define porte_lb_ln_write(val)			do{LATE = ((LATE & 0xFFF0) | (val & 0x000F)) & porte_mask();}while(0)
#define porte_lb_ln_read()				(PORTE & porte_mask() & 0x000F)
#define porte_lb_ln_lat_read()			(LATE & porte_mask() & 0x000F)

#define porte_pin_set(pin)            	    porte_##pin##_write(1)
#define porte_pin_clear(pin)            	porte_##pin##_write(0)
#define porte_pin_make_output(pin)		    porte_##pin##_make_output()
#define porte_pin_make_input(pin)		    porte_##pin##_make_input()
#define porte_pin_write(pin,val)      	    porte_##pin##_write(val)
#define porte_pin_read(pin)	        	    porte_##pin##_read()
#define porte_pin_lat_read(pin)	            porte_##pin##_lat_read()
#define porte_pin_toggle(pin)               porte_##pin##_toggle()
#endif

#if porte_mask()&0x0001
#define porte_0_make_output()			do{TRISEbits.TRISE0 = 0;}while(0)
#define porte_0_make_input()			do{TRISEbits.TRISE0 = 1;}while(0)
#define porte_0_write(val)				do{LATEbits.LATE0 = val;}while(0)
#define porte_0_read()					(PORTEbits.RE0)
#define porte_0_lat_read()				(LATEbits.LATE0)
#define porte_0_toggle()				do{__builtin_btg((uint16_t *)&LATE,0);}while(0)
#endif
#if porte_mask()&0x0002
#define porte_1_make_output()			do{TRISEbits.TRISE1 = 0;}while(0)
#define porte_1_make_input()			do{TRISEbits.TRISE1 = 1;}while(0)
#define porte_1_write(val)				do{LATEbits.LATE1 = val;}while(0)
#define porte_1_read()					(PORTEbits.RE1)
#define porte_1_lat_read()				(LATEbits.LATE1)
#define porte_1_toggle()				do{__builtin_btg((uint16_t *)&LATE,1);}while(0)
#endif
#if porte_mask()&0x0004
#define porte_2_make_output()			do{TRISEbits.TRISE2 = 0;}while(0)
#define porte_2_make_input()			do{TRISEbits.TRISE2 = 1;}while(0)
#define porte_2_write(val)				do{LATEbits.LATE2 = val;}while(0)
#define porte_2_read()					(PORTEbits.RE2)
#define porte_2_lat_read()				(LATEbits.LATE2)
#define porte_2_toggle()				do{__builtin_btg((uint16_t *)&LATE,2);}while(0)
#endif
#if porte_mask()&0x0008
#define porte_3_make_output()			do{TRISEbits.TRISE3 = 0;}while(0)
#define porte_3_make_input()			do{TRISEbits.TRISE3 = 1;}while(0)
#define porte_3_write(val)				do{LATEbits.LATE3 = val;}while(0)
#define porte_3_read()					(PORTEbits.RE3)
#define porte_3_lat_read()				(LATEbits.LATE3)
#define porte_3_toggle()				do{__builtin_btg((uint16_t *)&LATE,3);}while(0)
#endif
#if porte_mask()&0x0010
#define porte_4_make_output()			do{TRISEbits.TRISE4 = 0;}while(0)
#define porte_4_make_input()			do{TRISEbits.TRISE4 = 1;}while(0)
#define porte_4_write(val)				do{LATEbits.LATE4 = val;}while(0)
#define porte_4_read()					(PORTEbits.RE4)
#define porte_4_lat_read()				(LATEbits.LATE4)
#define porte_4_toggle()				do{__builtin_btg((uint16_t *)&LATE,4);}while(0)
#endif
#if porte_mask()&0x0020
#define porte_5_make_output()			do{TRISEbits.TRISE5 = 0;}while(0)
#define porte_5_make_input()			do{TRISEbits.TRISE5 = 1;}while(0)
#define porte_5_write(val)				do{LATEbits.LATE5 = val;}while(0)
#define porte_5_read()					(PORTEbits.RE5)
#define porte_5_lat_read()				(LATEbits.LATE5)
#define porte_5_toggle()				do{__builtin_btg((uint16_t *)&LATE,5);}while(0)
#endif
#if porte_mask()&0x0040
#define porte_6_make_output()			do{TRISEbits.TRISE6 = 0;}while(0)
#define porte_6_make_input()			do{TRISEbits.TRISE6 = 1;}while(0)
#define porte_6_write(val)				do{LATEbits.LATE6 = val;}while(0)
#define porte_6_read()					(PORTEbits.RE6)
#define porte_6_lat_read()				(LATEbits.LATE6)
#define porte_6_toggle()				do{__builtin_btg((uint16_t *)&LATE,6);}while(0)
#endif
#if porte_mask()&0x0080
#define porte_7_make_output()			do{TRISEbits.TRISE7 = 0;}while(0)
#define porte_7_make_input()			do{TRISEbits.TRISE7 = 1;}while(0)
#define porte_7_write(val)				do{LATEbits.LATE7 = val;}while(0)
#define porte_7_read()					(PORTEbits.RE7)
#define porte_7_lat_read()				(LATEbits.LATE7)
#define porte_7_toggle()				do{__builtin_btg((uint16_t *)&LATE,7);}while(0)
#endif
#if porte_mask()&0x0100
#define porte_8_make_output()			do{TRISEbits.TRISE8 = 0;}while(0)
#define porte_8_make_input()			do{TRISEbits.TRISE8 = 1;}while(0)
#define porte_8_write(val)				do{LATEbits.LATE8 = val;}while(0)
#define porte_8_read()					(PORTEbits.RE8)
#define porte_8_lat_read()				(LATEbits.LATE8)
#define porte_8_toggle()				do{__builtin_btg((uint16_t *)&LATE,8);}while(0)
#endif
#if porte_mask()&0x0200
#define porte_9_make_output()			do{TRISEbits.TRISE9 = 0;}while(0)
#define porte_9_make_input()			do{TRISEbits.TRISE9 = 1;}while(0)
#define porte_9_write(val)				do{LATEbits.LATE9 = val;}while(0)
#define porte_9_read()					(PORTEbits.RE9)
#define porte_9_lat_read()				(LATEbits.LATE9)
#define porte_9_toggle()				do{__builtin_btg((uint16_t *)&LATE,9);}while(0)
#endif
#if porte_mask()&0x0400
#define porte_10_make_output()			do{TRISEbits.TRISE10 = 0;}while(0)
#define porte_10_make_input()			do{TRISEbits.TRISE10 = 1;}while(0)
#define porte_10_write(val)				do{LATEbits.LATE10 = val;}while(0)
#define porte_10_read()					(PORTEbits.RE10)
#define porte_10_lat_read()				(LATEbits.LATE10)
#define porte_10_toggle()				do{__builtin_btg((uint16_t *)&LATE,10);}while(0)
#endif
#if porte_mask()&0x0800
#define porte_11_make_output()			do{TRISEbits.TRISE11 = 0;}while(0)
#define porte_11_make_input()			do{TRISEbits.TRISE11 = 1;}while(0)
#define porte_11_write(val)				do{LATEbits.LATE11 = val;}while(0)
#define porte_11_read()					(PORTEbits.RE11)
#define porte_11_lat_read()				(LATEbits.LATE11)
#define porte_11_toggle()				do{__builtin_btg((uint16_t *)&LATE,11);}while(0)
#endif
#if porte_mask()&0x1000
#define porte_12_make_output()			do{TRISEbits.TRISE12 = 0;}while(0)
#define porte_12_make_input()			do{TRISEbits.TRISE12 = 1;}while(0)
#define porte_12_write(val)				do{LATEbits.LATE12 = val;}while(0)
#define porte_12_read()					(PORTEbits.RE12)
#define porte_12_lat_read()				(LATEbits.LATE12)
#define porte_12_toggle()				do{__builtin_btg((uint16_t *)&LATE,12);}while(0)
#endif
#if porte_mask()&0x2000
#define porte_13_make_output()			do{TRISEbits.TRISE13 = 0;}while(0)
#define porte_13_make_input()			do{TRISEbits.TRISE13 = 1;}while(0)
#define porte_13_write(val)				do{LATEbits.LATE13 = val;}while(0)
#define porte_13_read()					(PORTEbits.RE13)
#define porte_13_lat_read()				(LATEbits.LATE13)
#define porte_13_toggle()				do{__builtin_btg((uint16_t *)&LATE,13);}while(0)
#endif
#if porte_mask()&0x4000
#define porte_14_make_output()			do{TRISEbits.TRISE14 = 0;}while(0)
#define porte_14_make_input()			do{TRISEbits.TRISE14 = 1;}while(0)
#define porte_14_write(val)				do{LATEbits.LATE14 = val;}while(0)
#define porte_14_read()					(PORTEbits.RE14)
#define porte_14_lat_read()				(LATEbits.LATE14)
#define porte_14_toggle()				do{__builtin_btg((uint16_t *)&LATE,14);}while(0)
#endif
#if porte_mask()&0x8000
#define porte_15_make_output()			do{TRISEbits.TRISE15 = 0;}while(0)
#define porte_15_make_input()			do{TRISEbits.TRISE15 = 0;}while(0)
#define porte_15_write(val)				do{LATEbits.LATE15 = val;}while(0)
#define porte_15_read()					(PORTEbits.RE15)
#define porte_15_lat_read()				(LATEbits.LATE15)
#define porte_15_toggle()				do{__builtin_btg((uint16_t *)&LATE,15);}while(0)
#endif


/*///////////////////// PORT F ////////////////////////////*/
#if portf_mask() != 0
#define portf_make_output()				do{TRISF = 0x0000;}while(0)
#define portf_make_input()		        do{TRISF = 0xFFFF;}while(0)
#define portf_write(val)				do{LATF = (val & portf_mask());}while(0)
#define portf_read()					(PORTF & portf_mask())
#define portf_lat_read()				(LATF & portf_mask())
#define portf_make_output_low()         do{portf_make_output();portf_write(0x0000);}while(0);

#define portf_ub_make_output()			do{TRISF &= 0x00FF;}while(0)
#define portf_ub_make_input()		    do{TRISF |= 0xFF00;}while(0)
#define portf_ub_write(val)				do{LATF = ((LATF & 0x00FF) | ((val << 8) & 0xFF00)) & portf_mask();}while(0)
#define portf_ub_read()					(((PORTF & portf_mask()) >> 8) & 0x00FF )
#define portf_ub_lat_read()				(((LATF & portf_mask()) >> 8) & 0x00FF )

#define portf_lb_make_output()			do{TRISF &= 0xFF00;}while(0)
#define portf_lb_input()		        do{TRISF |= 0x00FF;}while(0)
#define portf_lb_write(val)				do{LATF = ((LATF & 0xFF00) | (val & 0x00FF)) & portf_mask();}while(0)
#define portf_lb_read()					(PORTF & 0x00FF & portf_mask())
#define portf_lb_lat_read()				(LATF & 0x00FF & portf_mask())

#define portf_ub_un_make_output()		do{TRISF &= 0x0FFF;}while(0)
#define portf_ub_un_make_input()		do{TRISF |= 0xF000;}while(0)
#define portf_ub_un_write(val)			do{LATF = ((LATF & 0x0FFF) | ((val << 12) & 0xF000)) & portf_mask();}while(0)
#define portf_ub_un_read()				(((PORTF & portf_mask()) >> 12) & 0x000F)
#define portf_ub_un_lat_read()			(((LATF & portf_mask()) >> 12) & 0x000F )

#define portf_ub_ln_make_output()		do{TRISF &= 0xF0FF;}while(0)
#define portf_ub_ln_make_input()		do{TRISF |= 0x0F00;}while(0)
#define portf_ub_ln_write(val)			do{LATF = ((LATF & 0xF0FF) | ((val << 8) & 0x0F00)) & portf_mask();}while(0)
#define portf_ub_ln_read()				(((PORTF & portf_mask()) >> 8) & 0x000F )
#define portf_ub_ln_lat_read()			(((LATF & portf_mask()) >> 8) & 0x000F )

#define portf_lb_un_make_output()		do{TRISF &= 0xFF0F;}while(0)
#define portf_lb_un_make_input()		do{TRISF |= 0x00F0;}while(0)
#define portf_lb_un_write(val)			do{LATF = ((LATF & 0xFF0F) | (val & 0x00F0)) & portf_mask();}while(0)
#define portf_lb_un_read()				(((PORTF & portf_mask()) >> 4) & 0x000F )
#define portf_lb_un_lat_read()			(((LATF& portf_mask()) >> 4) & 0x000F )

#define portf_lb_ln_make_output()		do{TRISF &= 0xFFF0;}while(0)
#define portf_lb_ln_make_input()		do{TRISF |= 0x000F;}while(0)
#define portf_lb_ln_write(val)			do{LATF = ((LATF & 0xFFF0) | (val & 0x000F)) & portf_mask();}while(0)
#define portf_lb_ln_read()				(PORTF & portf_mask() & 0x000F)
#define portf_lb_ln_lat_read()			(LATF & portf_mask() & 0x000F)

#define portf_pin_set(pin)            	    portf_##pin##_write(1)
#define portf_pin_clear(pin)            	portf_##pin##_write(0)
#define portf_pin_make_output(pin)		    portf_##pin##_make_output()
#define portf_pin_make_input(pin)		    portf_##pin##_make_input()
#define portf_pin_write(pin,val)      	    portf_##pin##_write(val)
#define portf_pin_read(pin)	        	    portf_##pin##_read()
#define portf_pin_lat_read(pin)	            portf_##pin##_lat_read()
#define portf_pin_toggle(pin)               portf_##pin##_toggle()
#endif

#if portf_mask()&0x0001
#define portf_0_make_output()			do{TRISFbits.TRISF0 = 0;}while(0)
#define portf_0_make_input()			do{TRISFbits.TRISF0 = 1;}while(0)
#define portf_0_write(val)				do{LATFbits.LATF0 = val;}while(0)
#define portf_0_read()					(PORTFbits.RF0)
#define portf_0_lat_read()				(LATFbits.LATF0)
#define portf_0_toggle()				do{__builtin_btg((uint16_t *)&LATF,0);}while(0)
#endif
#if portf_mask()&0x0002
#define portf_1_make_output()			do{TRISFbits.TRISF1 = 0;}while(0)
#define portf_1_make_input()			do{TRISFbits.TRISF1 = 1;}while(0)
#define portf_1_write(val)				do{LATFbits.LATF1 = val;}while(0)
#define portf_1_read()					(PORTFbits.RF1)
#define portf_1_lat_read()				(LATFbits.LATF1)
#define portf_1_toggle()				do{__builtin_btg((uint16_t *)&LATF,1);}while(0)
#endif
#if portf_mask()&0x0004
#define portf_2_make_output()			do{TRISFbits.TRISF2 = 0;}while(0)
#define portf_2_make_input()			do{TRISFbits.TRISF2 = 1;}while(0)
#define portf_2_write(val)				do{LATFbits.LATF2 = val;}while(0)
#define portf_2_read()					(PORTFbits.RF2)
#define portf_2_lat_read()				(LATFbits.LATF2)
#define portf_2_toggle()				do{__builtin_btg((uint16_t *)&LATF,2);}while(0)
#endif
#if portf_mask()&0x0008
#define portf_3_make_output()			do{TRISFbits.TRISF3 = 0;}while(0)
#define portf_3_make_input()			do{TRISFbits.TRISF3 = 1;}while(0)
#define portf_3_write(val)				do{LATFbits.LATF3 = val;}while(0)
#define portf_3_read()					(PORTFbits.RF3)
#define portf_3_lat_read()				(LATFbits.LATF3)
#define portf_3_toggle()				do{__builtin_btg((uint16_t *)&LATF,3);}while(0)
#endif
#if portf_mask()&0x0010
#define portf_4_make_output()			do{TRISFbits.TRISF4 = 0;}while(0)
#define portf_4_make_input()			do{TRISFbits.TRISF4 = 1;}while(0)
#define portf_4_write(val)				do{LATFbits.LATF4 = val;}while(0)
#define portf_4_read()					(PORTFbits.RF4)
#define portf_4_lat_read()				(LATFbits.LATF4)
#define portf_4_toggle()				do{__builtin_btg((uint16_t *)&LATF,4);}while(0)
#endif
#if portf_mask()&0x0020
#define portf_5_make_output()			do{TRISFbits.TRISF5 = 0;}while(0)
#define portf_5_make_input()			do{TRISFbits.TRISF5 = 1;}while(0)
#define portf_5_write(val)				do{LATFbits.LATF5 = val;}while(0)
#define portf_5_read()					(PORTFbits.RF5)
#define portf_5_lat_read()				(LATFbits.LATF5)
#define portf_5_toggle()				do{__builtin_btg((uint16_t *)&LATF,5);}while(0)
#endif
#if portf_mask()&0x0040
#define portf_6_make_output()			do{TRISFbits.TRISF6 = 0;}while(0)
#define portf_6_make_input()			do{TRISFbits.TRISF6 = 1;}while(0)
#define portf_6_write(val)				do{LATFbits.LATF6 = val;}while(0)
#define portf_6_read()					(PORTFbits.RF6)
#define portf_6_lat_read()				(LATFbits.LATF6)
#define portf_6_toggle()				do{__builtin_btg((uint16_t *)&LATF,6);}while(0)
#endif
#if portf_mask()&0x0080
#define portf_7_make_output()			do{TRISFbits.TRISF7 = 0;}while(0)
#define portf_7_make_input()			do{TRISFbits.TRISF7 = 1;}while(0)
#define portf_7_write(val)				do{LATFbits.LATF7 = val;}while(0)
#define portf_7_read()					(PORTFbits.RF7)
#define portf_7_lat_read()				(LATFbits.LATF7)
#define portf_7_toggle()				do{__builtin_btg((uint16_t *)&LATF,7);}while(0)
#endif
#if portf_mask()&0x0100
#define portf_8_make_output()			do{TRISFbits.TRISF8 = 0;}while(0)
#define portf_8_make_input()			do{TRISFbits.TRISF8 = 1;}while(0)
#define portf_8_write(val)				do{LATFbits.LATF8 = val;}while(0)
#define portf_8_read()					(PORTFbits.RF8)
#define portf_8_lat_read()				(LATFbits.LATF8)
#define portf_8_toggle()				do{__builtin_btg((uint16_t *)&LATF,8);}while(0)
#endif
#if portf_mask()&0x0200
#define portf_9_make_output()			do{TRISFbits.TRISF9 = 0;}while(0)
#define portf_9_make_input()			do{TRISFbits.TRISF9 = 1;}while(0)
#define portf_9_write(val)				do{LATFbits.LATF9 = val;}while(0)
#define portf_9_read()					(PORTFbits.RF9)
#define portf_9_lat_read()				(LATFbits.LATF9)
#define portf_9_toggle()				do{__builtin_btg((uint16_t *)&LATF,9);}while(0)
#endif
#if portf_mask()&0x0400
#define portf_10_make_output()			do{TRISFbits.TRISF10 = 0;}while(0)
#define portf_10_make_input()			do{TRISFbits.TRISF10 = 1;}while(0)
#define portf_10_write(val)				do{LATFbits.LATF10 = val;}while(0)
#define portf_10_read()					(PORTFbits.RF10)
#define portf_10_lat_read()				(LATFbits.LATF10)
#define portf_10_toggle()				do{__builtin_btg((uint16_t *)&LATF,10);}while(0)
#endif
#if portf_mask()&0x0800
#define portf_11_make_output()			do{TRISFbits.TRISF11 = 0;}while(0)
#define portf_11_make_input()			do{TRISFbits.TRISF11 = 1;}while(0)
#define portf_11_write(val)				do{LATFbits.LATF11 = val;}while(0)
#define portf_11_read()					(PORTFbits.RF11)
#define portf_11_lat_read()				(LATFbits.LATF11)
#define portf_11_toggle()				do{__builtin_btg((uint16_t *)&LATF,11);}while(0)
#endif
#if portf_mask()&0x1000
#define portf_12_make_output()			do{TRISFbits.TRISF12 = 0;}while(0)
#define portf_12_make_input()			do{TRISFbits.TRISF12 = 1;}while(0)
#define portf_12_write(val)				do{LATFbits.LATF12 = val;}while(0)
#define portf_12_read()					(PORTFbits.RF12)
#define portf_12_lat_read()				(LATFbits.LATF12)
#define portf_12_toggle()				do{__builtin_btg((uint16_t *)&LATF,12);}while(0)
#endif
#if portf_mask()&0x2000
#define portf_13_make_output()			do{TRISFbits.TRISF13 = 0;}while(0)
#define portf_13_make_input()			do{TRISFbits.TRISF13 = 1;}while(0)
#define portf_13_write(val)				do{LATFbits.LATF13 = val;}while(0)
#define portf_13_read()					(PORTFbits.RF13)
#define portf_13_lat_read()				(LATFbits.LATF13)
#define portf_13_toggle()				do{__builtin_btg((uint16_t *)&LATF,13);}while(0)
#endif
#if portf_mask()&0x4000
#define portf_14_make_output()			do{TRISFbits.TRISF14 = 0;}while(0)
#define portf_14_make_input()			do{TRISFbits.TRISF14 = 1;}while(0)
#define portf_14_write(val)				do{LATFbits.LATF14 = val;}while(0)
#define portf_14_read()					(PORTFbits.RF14)
#define portf_14_lat_read()				(LATFbits.LATF14)
#define portf_14_toggle()				do{__builtin_btg((uint16_t *)&LATF,14);}while(0)
#endif
#if portf_mask()&0x8000
#define portf_15_make_output()			do{TRISFbits.TRISF15 = 0;}while(0)
#define portf_15_make_input()			do{TRISFbits.TRISF15 = 0;}while(0)
#define portf_15_write(val)				do{LATFbits.LATF15 = val;}while(0)
#define portf_15_read()					(PORTFbits.RF15)
#define portf_15_lat_read()				(LATFbits.LATF15)
#define portf_15_toggle()				do{__builtin_btg((uint16_t *)&LATF,15);}while(0)
#endif

/*///////////////////// PORT G ////////////////////////////*/
#if portg_mask() != 0
#define portg_make_output()				do{TRISG = 0x0000;}while(0)
#define portg_make_input()		        do{TRISG = 0xFFFF;}while(0)
#define portg_write(val)				do{LATG = (val & portg_mask());}while(0)
#define portg_read()					(PORTG & portg_mask())
#define portg_lat_read()				(LATG & portg_mask())
#define portg_make_output_low()         do{portg_make_output();portg_write(0x0000);}while(0);

#define portg_ub_make_output()			do{TRISG &= 0x00FF;}while(0)
#define portg_ub_make_input()		    do{TRISG |= 0xFF00;}while(0)
#define portg_ub_write(val)				do{LATG = ((LATG & 0x00FF) | ((val << 8) & 0xFF00)) & portg_mask();}while(0)
#define portg_ub_read()					(((PORTG & portg_mask()) >> 8) & 0x00FF )
#define portg_ub_lat_read()				(((LATG & portg_mask()) >> 8) & 0x00FF )

#define portg_lb_make_output()			do{TRISG &= 0xFF00;}while(0)
#define portg_lb_input()		        do{TRISG |= 0x00FF;}while(0)
#define portg_lb_write(val)				do{LATG = ((LATG & 0xFF00) | (val & 0x00FF)) & portg_mask();}while(0)
#define portg_lb_read()					(PORTG & 0x00FF & portg_mask())
#define portg_lb_lat_read()				(LATG & 0x00FF & portg_mask())

#define portg_ub_un_make_output()		do{TRISG &= 0x0FFF;}while(0)
#define portg_ub_un_make_input()		do{TRISG |= 0xF000;}while(0)
#define portg_ub_un_write(val)			do{LATG = ((LATG & 0x0FFF) | ((val << 12) & 0xF000)) & portg_mask();}while(0)
#define portg_ub_un_read()				(((PORTG & portg_mask()) >> 12) & 0x000F)
#define portg_ub_un_lat_read()			(((LATG & portg_mask()) >> 12) & 0x000F )

#define portg_ub_ln_make_output()		do{TRISG &= 0xF0FF;}while(0)
#define portg_ub_ln_make_input()		do{TRISG |= 0x0F00;}while(0)
#define portg_ub_ln_write(val)			do{LATG = ((LATG & 0xF0FF) | ((val << 8) & 0x0F00)) & portg_mask();}while(0)
#define portg_ub_ln_read()				(((PORTG & portg_mask()) >> 8) & 0x000F )
#define portg_ub_ln_lat_read()			(((LATG & portg_mask()) >> 8) & 0x000F )

#define portg_lb_un_make_output()		do{TRISG &= 0xFF0F;}while(0)
#define portg_lb_un_make_input()		do{TRISG |= 0x00F0;}while(0)
#define portg_lb_un_write(val)			do{LATG = ((LATG & 0xFF0F) | (val & 0x00F0)) & portg_mask();}while(0)
#define portg_lb_un_read()				(((PORTG & portg_mask()) >> 4) & 0x000F )
#define portg_lb_un_lat_read()			(((LATG& portg_mask()) >> 4) & 0x000F )

#define portg_lb_ln_make_output()		do{TRISG &= 0xFFF0;}while(0)
#define portg_lb_ln_make_input()		do{TRISG |= 0x000F;}while(0)
#define portg_lb_ln_write(val)			do{LATG = ((LATG & 0xFFF0) | (val & 0x000F)) & portg_mask();}while(0)
#define portg_lb_ln_read()				(PORTG & portg_mask() & 0x000F)
#define portg_lb_ln_lat_read()			(LATG & portg_mask() & 0x000F)

#define portg_pin_set(pin)            	    portg_##pin##_write(1)
#define portg_pin_clear(pin)            	portg_##pin##_write(0)
#define portg_pin_make_output(pin)		    portg_##pin##_make_output()
#define portg_pin_make_input(pin)		    portg_##pin##_make_input()
#define portg_pin_write(pin,val)      	    portg_##pin##_write(val)
#define portg_pin_read(pin)	        	    portg_##pin##_read()
#define portg_pin_lat_read(pin)	            portg_##pin##_lat_read()
#define portg_pin_toggle(pin)               portg_##pin##_toggle()
#endif

#if portg_mask()&0x0001
#define portg_0_make_output()			do{TRISGbits.TRISG0 = 0;}while(0)
#define portg_0_make_input()			do{TRISGbits.TRISG0 = 1;}while(0)
#define portg_0_write(val)				do{LATGbits.LATG0 = val;}while(0)
#define portg_0_read()					(PORTGbits.RG0)
#define portg_0_lat_read()				(LATGbits.LATG0)
#define portg_0_toggle()				do{__builtin_btg((uint16_t *)&LATG,0);}while(0)
#endif
#if portg_mask()&0x0002
#define portg_1_make_output()			do{TRISGbits.TRISG1 = 0;}while(0)
#define portg_1_make_input()			do{TRISGbits.TRISG1 = 1;}while(0)
#define portg_1_write(val)				do{LATGbits.LATG1 = val;}while(0)
#define portg_1_read()					(PORTGbits.RG1)
#define portg_1_lat_read()				(LATGbits.LATG1)
#define portg_1_toggle()				do{__builtin_btg((uint16_t *)&LATG,1);}while(0)
#endif
#if portg_mask()&0x0004
#define portg_2_make_output()			do{TRISGbits.TRISG2 = 0;}while(0)
#define portg_2_make_input()			do{TRISGbits.TRISG2 = 1;}while(0)
#define portg_2_write(val)				do{LATGbits.LATG2 = val;}while(0)
#define portg_2_read()					(PORTGbits.RG2)
#define portg_2_lat_read()				(LATGbits.LATG2)
#define portg_2_toggle()				do{__builtin_btg((uint16_t *)&LATG,2);}while(0)
#endif
#if portg_mask()&0x0008
#define portg_3_make_output()			do{TRISGbits.TRISG3 = 0;}while(0)
#define portg_3_make_input()			do{TRISGbits.TRISG3 = 1;}while(0)
#define portg_3_write(val)				do{LATGbits.LATG3 = val;}while(0)
#define portg_3_read()					(PORTGbits.RG3)
#define portg_3_lat_read()				(LATGbits.LATG3)
#define portg_3_toggle()				do{__builtin_btg((uint16_t *)&LATG,3);}while(0)
#endif
#if portg_mask()&0x0010
#define portg_4_make_output()			do{TRISGbits.TRISG4 = 0;}while(0)
#define portg_4_make_input()			do{TRISGbits.TRISG4 = 1;}while(0)
#define portg_4_write(val)				do{LATGbits.LATG4 = val;}while(0)
#define portg_4_read()					(PORTGbits.RG4)
#define portg_4_lat_read()				(LATGbits.LATG4)
#define portg_4_toggle()				do{__builtin_btg((uint16_t *)&LATG,4);}while(0)
#endif
#if portg_mask()&0x0020
#define portg_5_make_output()			do{TRISGbits.TRISG5 = 0;}while(0)
#define portg_5_make_input()			do{TRISGbits.TRISG5 = 1;}while(0)
#define portg_5_write(val)				do{LATGbits.LATG5 = val;}while(0)
#define portg_5_read()					(PORTGbits.RG5)
#define portg_5_lat_read()				(LATGbits.LATG5)
#define portg_5_toggle()				do{__builtin_btg((uint16_t *)&LATG,5);}while(0)
#endif
#if portg_mask()&0x0040
#define portg_6_make_output()			do{TRISGbits.TRISG6 = 0;}while(0)
#define portg_6_make_input()			do{TRISGbits.TRISG6 = 1;}while(0)
#define portg_6_write(val)				do{LATGbits.LATG6 = val;}while(0)
#define portg_6_read()					(PORTGbits.RG6)
#define portg_6_lat_read()				(LATGbits.LATG6)
#define portg_6_toggle()				do{__builtin_btg((uint16_t *)&LATG,6);}while(0)
#endif
#if portg_mask()&0x0080
#define portg_7_make_output()			do{TRISGbits.TRISG7 = 0;}while(0)
#define portg_7_make_input()			do{TRISGbits.TRISG7 = 1;}while(0)
#define portg_7_write(val)				do{LATGbits.LATG7 = val;}while(0)
#define portg_7_read()					(PORTGbits.RG7)
#define portg_7_lat_read()				(LATGbits.LATG7)
#define portg_7_toggle()				do{__builtin_btg((uint16_t *)&LATG,7);}while(0)
#endif
#if portg_mask()&0x0100
#define portg_8_make_output()			do{TRISGbits.TRISG8 = 0;}while(0)
#define portg_8_make_input()			do{TRISGbits.TRISG8 = 1;}while(0)
#define portg_8_write(val)				do{LATGbits.LATG8 = val;}while(0)
#define portg_8_read()					(PORTGbits.RG8)
#define portg_8_lat_read()				(LATGbits.LATG8)
#define portg_8_toggle()				do{__builtin_btg((uint16_t *)&LATG,8);}while(0)
#endif
#if portg_mask()&0x0200
#define portg_9_make_output()			do{TRISGbits.TRISG9 = 0;}while(0)
#define portg_9_make_input()			do{TRISGbits.TRISG9 = 1;}while(0)
#define portg_9_write(val)				do{LATGbits.LATG9 = val;}while(0)
#define portg_9_read()					(PORTGbits.RG9)
#define portg_9_lat_read()				(LATGbits.LATG9)
#define portg_9_toggle()				do{__builtin_btg((uint16_t *)&LATG,9);}while(0)
#endif
#if portg_mask()&0x0400
#define portg_10_make_output()			do{TRISGbits.TRISG10 = 0;}while(0)
#define portg_10_make_input()			do{TRISGbits.TRISG10 = 1;}while(0)
#define portg_10_write(val)				do{LATGbits.LATG10 = val;}while(0)
#define portg_10_read()					(PORTGbits.RG10)
#define portg_10_lat_read()				(LATGbits.LATG10)
#define portg_10_toggle()				do{__builtin_btg((uint16_t *)&LATG,10);}while(0)
#endif
#if portg_mask()&0x0800
#define portg_11_make_output()			do{TRISGbits.TRISG11 = 0;}while(0)
#define portg_11_make_input()			do{TRISGbits.TRISG11 = 1;}while(0)
#define portg_11_write(val)				do{LATGbits.LATG11 = val;}while(0)
#define portg_11_read()					(PORTGbits.RG11)
#define portg_11_lat_read()				(LATGbits.LATG11)
#define portg_11_toggle()				do{__builtin_btg((uint16_t *)&LATG,11);}while(0)
#endif
#if portg_mask()&0x1000
#define portg_12_make_output()			do{TRISGbits.TRISG12 = 0;}while(0)
#define portg_12_make_input()			do{TRISGbits.TRISG12 = 1;}while(0)
#define portg_12_write(val)				do{LATGbits.LATG12 = val;}while(0)
#define portg_12_read()					(PORTGbits.RG12)
#define portg_12_lat_read()				(LATGbits.LATG12)
#define portg_12_toggle()				do{__builtin_btg((uint16_t *)&LATG,12);}while(0)
#endif
#if portg_mask()&0x2000
#define portg_13_make_output()			do{TRISGbits.TRISG13 = 0;}while(0)
#define portg_13_make_input()			do{TRISGbits.TRISG13 = 1;}while(0)
#define portg_13_write(val)				do{LATGbits.LATG13 = val;}while(0)
#define portg_13_read()					(PORTGbits.RG13)
#define portg_13_lat_read()				(LATGbits.LATG13)
#define portg_13_toggle()				do{__builtin_btg((uint16_t *)&LATG,13);}while(0)
#endif
#if portg_mask()&0x4000
#define portg_14_make_output()			do{TRISGbits.TRISG14 = 0;}while(0)
#define portg_14_make_input()			do{TRISGbits.TRISG14 = 1;}while(0)
#define portg_14_write(val)				do{LATGbits.LATG14 = val;}while(0)
#define portg_14_read()					(PORTGbits.RG14)
#define portg_14_lat_read()				(LATGbits.LATG14)
#define portg_14_toggle()				do{__builtin_btg((uint16_t *)&LATG,14);}while(0)
#endif
#if portg_mask()&0x8000
#define portg_15_make_output()			do{TRISGbits.TRISG15 = 0;}while(0)
#define portg_15_make_input()			do{TRISGbits.TRISG15 = 0;}while(0)
#define portg_15_write(val)				do{LATGbits.LATG15 = val;}while(0)
#define portg_15_read()					(PORTGbits.RG15)
#define portg_15_lat_read()				(LATGbits.LATG15)
#define portg_15_toggle()				do{__builtin_btg((uint16_t *)&LATG,15);}while(0)
#endif

#endif
