//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Main program file
//
// Language: Microchip C30
//
// File:     main.c
// Author: S1axter - MyBitBox.com
// Created: 6/29/2013
//
//////////////////////////////////////////////////////////////////////////////////////////////////////
#include "string.h"
#include "stdio.h"

#include "defs.h"

#include "port.h"

#include "swtimer.h"
#include "timer.h"

#include "main.h"

#define led1(func)  portb_0_##func

// Xtal selection
_FOSCSEL(FNOSC_FRC & IESO_OFF & SOSCSRC_DIG);

// OSCIOFNC_ON = Clock/2 output on CLKO, OSCIOFNC_OFF = No clock out
_FOSC(FCKSM_CSDCMD & OSCIOFNC_OFF & POSCMOD_NONE);

// Setup configuration bits
_FBS(BWRP_OFF & BSS_OFF);
_FGS(GSS0_OFF & GWRP_OFF);

_FWDT(0xFF5F);	// ; WDT disabled in hardware; SWDTEN bit disabled
//_FPOR(MCLRE_OFF & PWRTEN_OFF & BOREN_BOR0);
_FPOR(0xF0);

// Select programming pins
//_FICD(ICS_PGx1);
//_FICD(ICS_PGx2);
_FICD(ICS_PGx3);

void softtimer_A_callback();

swtimer_obj_t  soft_timer_A;

int main(void)
{
    // Setup Clock
    //////////////////////////////////////////////////////////////
    OSCTUN=0x00;		// Center frequency, no adjustments yet
    CLKDIV = 0x00;
    REFOCON = 0;
    // Let the clock settle a little from power on
    asm("mov.w #0x2FFF,W0");
    asm("dec	W0,W0");
    asm("bra	NZ,$-2");
    U1MODE = 0;
    U1STA = 0;

    // Setup system
    //////////////////////////////////////////////////////////////

    interrupts_disable();

    // Clear timer 2
    timer_init();

    interrupts_enable();
    
    /////////////////////////////////////////////////////////////////////
    // END OF SETUP
    /////////////////////////////////////////////////////////////////////

    // TIMER RELATED STUFF
    // Start out at 1000 Hz
    // This is for the swtimer
    timer_setup(1, 7, TIMER_PRESCALE_1_64_, (4000000/64), 1000);

    porta_make_input();
    portb_make_input();

    // Everything digital
    porta_make_digital();
    portb_make_digital();

    led1(make_output());    // porta_7_make_output(); -> BCLR LATA, #7
    led1(write(1));

    
    swtimer_new(soft_timer_A, 50, softtimer_A_callback);
    swtimer_on(soft_timer_A);


    /////////////////////////////////////////////////////////////////////
    // END OF THE INIT SECTION
    /////////////////////////////////////////////////////////////////////

    
    // Main, always running program loop
    //////////////////////////////////////////////////////////////
    nop();
    while(1)
    {
        // Process functions
        //////////////////////////////////////////////
        swtimer_process();
    }

    return 0;
}


void __attribute__((interrupt,no_auto_psv)) _T1Interrupt( void )
{
    timer_1_interrupt_flag_clear();
    swtimer_increment(1);
    return;
}

void softtimer_A_callback()
{

    nop();
    nop();
    led1(toggle());
 
    return;
}


//end
