//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// PIC24FV Intrinsics file
//
// Language: Microchip C30/XC16
//
// File:     intrinsics.h
// Author: S1axter - MyBitBox.com
// Created: 6/29/2013
//
// This file was created to be specific to the PIC24FV seris of processors.
//
//////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef __INTRINSICS_H__
#define __INTRINSICS_H__

#define _builtin_swap_word(n) asm volatile ("swap %0" : "+r"(n))

#define nop()       do{asm ("nop");}while(0)


#define _reset_basic() do{RCONbits.POR = 0;asm("reset");}while(0)
#define _reset_por() do{RCONbits.POR = 1;asm("reset");}while(0)

#define psv_enable() do{CORCONbits.PSV = 1;}while(0)
#define psv_disable() do{CORCONbits.PSV = 0;}while(0)

#define interrupts_nested_enable()    do{INTCON1bits.NSTDIS = 0;}while(0)
#define interrupts_nested_disable()    do{INTCON1bits.NSTDIS = 1;}while(0)

/* Set CPU IPL to 0, enable level 1-7 interrupts */
/* No restoring of previous CPU IPL state performed here */
#define interrupts_enable()    do{SRbits.IPL = 0;}while(0)

/* Set CPU IPL to 7, disable level 1-7 interrupts */
/* No saving of current CPU IPL setting performed here */
#define interrupts_disable()    do{SRbits.IPL = 7;}while(0)


#endif
