//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Functions/variables related to general sub-systems
//
// Language: MBED C++ (C conventions)
//
// File:     system.c
// Author:   S1axter myBitBox.com
// Created:  8/20/11
//
//////////////////////////////////////////////////////////////////////////////////////////////////////

#include "mbed.h"

#include "defs.h"

#include "system.h"
#include "main.h"

// These are the system wide flags
volatile struct status_flags sys_status;
volatile struct time_flags sys_time;

// These are counters for time, set in the "interrupt"
uint8_t counter_base;
uint8_t counter_100ms;
uint8_t counter_1sec;
uint8_t counter_1min;

void ISR_timer1() {

    sys_time.time_1ms = true;
    counter_base++;
    
    if(counter_base>100)
    {
        counter_base = 0;
        
        sys_time.time_100ms = true;
        counter_100ms++;
        
        // This is for 1 sec
        if(counter_100ms >= 10)
        {
            counter_100ms = 0;
            counter_1sec++;
            sys_time.time_1sec = true;
            // This is for 1min
            if(counter_1sec>=60)
            {
                counter_1sec = 0;
                counter_1min++;
                if(counter_1min>200) counter_1min = 200;
            }
        }
        
    }

    return;
}

void system_SetupSubsystems()
{
    system_SetupVars();
    
    // Setup the 100ms "interrupt"
    timer1.attach(&ISR_timer1, 0.001);
       
    pc.baud(9600);
    pc.printf("System Startup Complete\n");

    return;
}

void system_SetupVars()
{
    counter_base = 0;
    counter_100ms = 0;
    counter_1sec = 0;
    counter_1min = 0;

    // Blank the flag variables
    memset((uint8_t*)&sys_status,0,sizeof(sys_status));
    memset((uint8_t*)&sys_time,0,sizeof(sys_time));
    
    return;
}


void system_CheckPins()
{
    return;
}


// end
