//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Main program
//
// Language: MBED C++ (C conventions)
//
// File:     main.cpp
// Author:   S1axter myBitBox.com
// Created:  8/20/11
//
//////////////////////////////////////////////////////////////////////////////////////////////////////

#include "mbed.h"
#include <string>

#include "defs.h"

#include "main.h"
#include "system.h"

// Define the systems in the MBED
Ticker timer1;
DigitalOut heartbeat(LED1);
Serial pc(USBTX, USBRX); // tx, rx

int main()
{

    // Sets up Timer ISR
    system_SetupSubsystems();

    // Set the heartbeat to true
    heartbeat = true;

    // Main loop
    while (1) {
        // UART handler
        if (pc.readable()) {
            main_ReadSerial();
        }

        // 1ms routine
        if (sys_time.time_1ms == true) {
            main_1msRoutine();
            sys_time.time_1ms = false;
        }
        // 100ms routine
        if (sys_time.time_100ms == true) {
            main_100msRoutine();
            sys_time.time_100ms = false;
        }
        // 1sec routine
        if (sys_time.time_1sec == true) {
            main_1secRoutine();
            sys_time.time_1sec = false;
        }

    }
    // Should never get here
}

void main_1msRoutine(void)
{
    // Do something
    return;
}

void main_100msRoutine(void)
{
    // Do something
    return;
}

void main_1secRoutine(void)
{
    // Toggle the LED
    heartbeat = !heartbeat;
    
    return;
}
















// This reads the UART for commands and does things like reboot the system
void main_ReadSerial()
{
    uint8_t input = pc.getc();
    if (input=='R') {
        mbed_reset();
    }
    if (input=='H') {
        heartbeat = false;
        while(1);
    }
    return;
}
