//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Definition Header file
//
// Language: MBED C++ (C conventions)
//
// File:     defs.h
// Author:   S1axter myBitBox.com
// Created:  8/20/11
//
//////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef __DEFS_H__
#define __DEFS_H__

//////////////////////////////////////////////////////////////////////////////////////////////////////
// System types
//////////////////////////////////////////////////////////////////////////////////////////////////////

#define int8_t     char
#define int16_t    int
#define int32_t    long
#define uint8_t    unsigned char
#define uint16_t   unsigned int
#define uint32_t   unsigned long

#define uchar_t    unsigned char
#define uint_t     unsigned int
#define ulong_t    unsigned long

//////////////////////////////////////////////////////////////////////////////////////////////////////
// System values
//////////////////////////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////////////////////////
// System Structures
//////////////////////////////////////////////////////////////////////////////////////////////////////

// System STATUS Structure
typedef struct status_flags{
    unsigned flag_ready         :1;
    unsigned flag_error         :1;
}sys_status_flags;
extern volatile struct status_flags sys_status;

// Time flags
typedef struct time_flags{
    unsigned time_1ms      :1;
    unsigned time_100ms     :1;
    unsigned time_1sec      :1;
}sys_time_flags;
extern volatile struct time_flags sys_time;

#endif
